/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import openblocks.Config;
import openblocks.shapes.GuideShape;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.geometry.HalfAxis;
import openmods.geometry.Orientation;
import openmods.shapes.IShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.sync.SyncableEnum;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableVarInt;
import openmods.sync.drops.DroppableTileEntity;
import openmods.sync.drops.StoreOnDrop;
import openmods.utils.CollectionUtils;
import openmods.utils.ColorUtils;
import openmods.utils.Coord;
import openmods.utils.MathUtils;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.struct.ScriptStruct;
import openperipheral.api.struct.StructField;

public class TileEntityGuide
extends DroppableTileEntity
implements ISyncListener,
INeighbourAwareTile,
IAddAwareTile {
    private static final Comparator<Coord> COORD_COMPARATOR = new Comparator<Coord>(){

        @Override
        public int compare(Coord o1, Coord o2) {
            double angle2;
            int result = Ints.compare((int)o1.y, (int)o2.y);
            if (result != 0) {
                return result;
            }
            double angle1 = Math.atan2(o1.z, o1.x);
            int result2 = Doubles.compare((double)angle1, (double)(angle2 = Math.atan2(o2.z, o2.x)));
            if (result2 != 0) {
                return result2;
            }
            double length1 = MathUtils.lengthSq((double)o1.x, (double)o1.z);
            double length2 = MathUtils.lengthSq((double)o2.x, (double)o2.z);
            result2 = Doubles.compare((double)length2, (double)length1);
            if (result2 != 0) {
                return result2;
            }
            result = Ints.compare((int)o1.x, (int)o2.x);
            if (result != 0) {
                return result;
            }
            result = Ints.compare((int)o1.z, (int)o2.z);
            return result;
        }
    };
    private List<Coord> shape;
    private List<Coord> previousShape;
    private float timeSinceChange = 0.0f;
    private AxisAlignedBB renderAABB;
    @StoreOnDrop(name="PosX")
    protected SyncableVarInt posX;
    @StoreOnDrop(name="PosY")
    protected SyncableVarInt posY;
    @StoreOnDrop(name="PosZ")
    protected SyncableVarInt posZ;
    @StoreOnDrop(name="NegX")
    protected SyncableVarInt negX;
    @StoreOnDrop(name="NegY")
    protected SyncableVarInt negY;
    @StoreOnDrop(name="NegZ")
    protected SyncableVarInt negZ;
    @StoreOnDrop(name="Mode")
    protected SyncableEnum<GuideShape> mode;
    @StoreOnDrop(name="Color")
    protected SyncableInt color;
    protected SyncableBoolean active;
    private final Map<HalfAxis, SyncableVarInt> axisDimensions = Maps.newEnumMap(HalfAxis.class);

    public TileEntityGuide() {
        this.syncMap.addUpdateListener((ISyncListener)this);
        this.axisDimensions.put(HalfAxis.NEG_X, this.negX);
        this.axisDimensions.put(HalfAxis.NEG_Y, this.negY);
        this.axisDimensions.put(HalfAxis.NEG_Z, this.negZ);
        this.axisDimensions.put(HalfAxis.POS_X, this.posX);
        this.axisDimensions.put(HalfAxis.POS_Y, this.posY);
        this.axisDimensions.put(HalfAxis.POS_Z, this.posZ);
    }

    protected void createSyncedFields() {
        this.posX = new SyncableVarInt(8);
        this.posY = new SyncableVarInt(8);
        this.posZ = new SyncableVarInt(8);
        this.negX = new SyncableVarInt(8);
        this.negY = new SyncableVarInt(8);
        this.negZ = new SyncableVarInt(8);
        this.mode = SyncableEnum.create((Enum)GuideShape.Sphere);
        this.color = new SyncableInt(0xFFFFFF);
        this.active = new SyncableBoolean();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.TABLE})
    public ShapeSize getSize() {
        ShapeSize result = new ShapeSize();
        result.negX = this.negX.get();
        result.negY = this.negY.get();
        result.negZ = this.negZ.get();
        result.posX = this.posX.get();
        result.posY = this.posY.get();
        result.posZ = this.posZ.get();
        return result;
    }

    @ScriptCallable
    public void setSize(ShapeSize size) {
        Preconditions.checkArgument((size.negX > 0 ? 1 : 0) != 0, (Object)"NegX must be > 0");
        this.negX.set(size.negX);
        Preconditions.checkArgument((size.negY > 0 ? 1 : 0) != 0, (Object)"NegY must be > 0");
        this.negY.set(size.negY);
        Preconditions.checkArgument((size.negZ > 0 ? 1 : 0) != 0, (Object)"NegZ must be > 0");
        this.negZ.set(size.negZ);
        Preconditions.checkArgument((size.posX > 0 ? 1 : 0) != 0, (Object)"PosX must be > 0");
        this.posX.set(size.posX);
        Preconditions.checkArgument((size.negY > 0 ? 1 : 0) != 0, (Object)"PosY must be > 0");
        this.posY.set(size.posY);
        Preconditions.checkArgument((size.negZ > 0 ? 1 : 0) != 0, (Object)"PosZ must be > 0");
        this.posZ.set(size.posZ);
        this.recreateShape();
        this.sync();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER})
    public int getColor() {
        return this.color.get() & 0xFFFFFF;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.NUMBER})
    public int getCount() {
        if (this.shape == null) {
            this.recreateShape();
        }
        return this.shape.size();
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.STRING}, name="getShape")
    public GuideShape getCurrentMode() {
        return (GuideShape)this.mode.get();
    }

    @ScriptCallable
    public void setShape(@Arg(name="shape") GuideShape shape) {
        this.mode.set((Enum)shape);
        this.recreateShape();
        this.sync();
    }

    @ScriptCallable
    public void setColor(@Arg(name="color") int color) {
        this.color.set(color & 0xFFFFFF);
        this.sync();
    }

    public boolean incrementHalfAxis(HalfAxis axis, EntityPlayerMP player) {
        SyncableVarInt v = this.axisDimensions.get(axis);
        v.modify(1);
        this.afterDimensionsChange((EntityPlayer)player);
        return true;
    }

    public boolean decrementHalfAxis(HalfAxis axis, EntityPlayerMP player) {
        SyncableVarInt v = this.axisDimensions.get(axis);
        if (v.get() > 0) {
            v.modify(-1);
            this.afterDimensionsChange((EntityPlayer)player);
            return true;
        }
        return false;
    }

    public boolean copyHalfAxis(HalfAxis from, HalfAxis to, EntityPlayerMP player) {
        SyncableVarInt fromV = this.axisDimensions.get(from);
        SyncableVarInt toV = this.axisDimensions.get(to);
        toV.set(fromV.get());
        this.afterDimensionsChange((EntityPlayer)player);
        return true;
    }

    public void incrementMode(EntityPlayer player) {
        this.incrementMode();
        this.displayModeChange(player);
        this.displayBlockCount(player);
    }

    public void decrementMode(EntityPlayer player) {
        this.decrementMode();
        this.displayModeChange(player);
        this.displayBlockCount(player);
    }

    private void displayModeChange(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.change_mode", new Object[]{this.getCurrentMode().getLocalizedName()}));
    }

    private void displayBlockCount(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.total_blocks", new Object[]{this.shape.size()}));
    }

    public boolean shouldRender() {
        return Config.guideRedstone == 0 || Config.guideRedstone < 0 ^ this.active.get();
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = this.generateShape();
        this.renderAABB = null;
    }

    private List<Coord> generateShape() {
        IShapeGenerator generator = this.getCurrentMode().generator;
        final HashSet uniqueResults = Sets.newHashSet();
        IShapeable collector = new IShapeable(){

            public void setBlock(int x, int y, int z) {
                if (TileEntityGuide.this.canAddCoord(x, y, z)) {
                    uniqueResults.add(new Coord(x, y, z));
                }
            }
        };
        generator.generateShape(-this.negX.get(), -this.negY.get(), -this.negZ.get(), this.posX.get(), this.posY.get(), this.posZ.get(), collector);
        ArrayList sortedResults = Lists.newArrayList((Iterable)uniqueResults);
        Collections.sort(sortedResults, COORD_COMPARATOR);
        ArrayList rotatedResult = Lists.newArrayList();
        Orientation orientation = this.getOrientation();
        for (Coord c : sortedResults) {
            int tx = orientation.transformX(c.x, c.y, c.z);
            int ty = orientation.transformY(c.x, c.y, c.z);
            int tz = orientation.transformZ(c.x, c.y, c.z);
            rotatedResult.add(new Coord(tx, ty, tz));
        }
        return ImmutableList.copyOf((Collection)rotatedResult);
    }

    protected boolean canAddCoord(int x, int y, int z) {
        return true;
    }

    public List<Coord> getShape() {
        return this.shape;
    }

    public List<Coord> getPreviousShape() {
        return this.previousShape;
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (!this.field_145850_b.field_72995_K) {
            this.recreateShape();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.createRenderAABB();
        }
        return this.renderAABB.func_72329_c();
    }

    private AxisAlignedBB createRenderAABB() {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        if (this.shape != null) {
            for (Coord c : this.shape) {
                if (box.field_72336_d < (double)c.x) {
                    box.field_72336_d = c.x;
                }
                if (box.field_72337_e < (double)c.y) {
                    box.field_72337_e = c.y;
                }
                if (box.field_72334_f < (double)c.z) {
                    box.field_72334_f = c.z;
                }
                if (box.field_72340_a > (double)c.x) {
                    box.field_72340_a = c.x;
                }
                if (box.field_72338_b > (double)c.y) {
                    box.field_72338_b = c.y;
                }
                if (!(box.field_72339_c > (double)c.z)) continue;
                box.field_72339_c = c.z;
            }
        }
        return box.func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Config.guideRenderRangeSq;
    }

    @Alias(value={"cycleShape"})
    @ScriptCallable(returnTypes={ReturnType.STRING})
    public GuideShape incrementMode() {
        GuideShape shape = (GuideShape)this.mode.increment();
        this.recreateShape();
        this.sync();
        return shape;
    }

    @ScriptCallable(returnTypes={ReturnType.STRING})
    public GuideShape decrementMode() {
        GuideShape shape = (GuideShape)this.mode.decrement();
        this.recreateShape();
        this.sync();
        return shape;
    }

    private void notifyPlayer(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.change_box_size", new Object[]{-this.negX.get(), -this.negY.get(), -this.negZ.get(), this.posX.get(), this.posY.get(), this.posZ.get()}));
        this.displayBlockCount(player);
    }

    private void afterDimensionsChange(EntityPlayer player) {
        this.recreateShape();
        this.sync();
        this.notifyPlayer(player);
    }

    public void onSync(Set<ISyncableObject> changes) {
        if (changes.contains(this.negX) || changes.contains(this.negY) || changes.contains(this.negZ) || changes.contains(this.posX) || changes.contains(this.posY) || changes.contains(this.posZ) || changes.contains(this.mode)) {
            this.recreateShape();
            this.timeSinceChange = 0.0f;
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.shouldRender();
    }

    private void updateRedstone() {
        if (Config.guideRedstone != 0) {
            boolean redstoneState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.active.set(redstoneState);
            this.sync();
        }
    }

    public void onNeighbourChanged(Block block) {
        this.updateRedstone();
    }

    public void onAdded() {
        this.updateRedstone();
    }

    protected List<Coord> getShapeSafe() {
        if (this.shape == null) {
            this.recreateShape();
        }
        return this.shape;
    }

    public boolean onItemUse(EntityPlayerMP player, ItemStack heldStack, int side, float hitX, float hitY, float hitZ) {
        Set colors = ColorUtils.stackToColor((ItemStack)heldStack);
        if (!colors.isEmpty()) {
            ColorUtils.ColorMeta selected = (ColorUtils.ColorMeta)CollectionUtils.getRandom((Collection)colors);
            this.color.set(selected.rgb);
            if (!this.field_145850_b.field_72995_K) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    @ScriptStruct
    public static class ShapeSize {
        @StructField
        public int negX;
        @StructField
        public int negY;
        @StructField
        public int negZ;
        @StructField
        public int posX;
        @StructField
        public int posY;
        @StructField
        public int posZ;
    }
}

