/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import openblocks.OpenBlocks;
import openblocks.common.PedometerHandler;
import openmods.utils.Units;

public class ItemPedometer
extends Item {
    private IIcon pedometerMoving;
    private IIcon pedometerStill;
    private Units.SpeedUnit speedUnit = Units.SpeedUnit.M_PER_TICK;
    private Units.DistanceUnit distanceUnit = Units.DistanceUnit.M;

    public ItemPedometer() {
        this.func_77625_d(1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        super.func_94581_a(registry);
        this.pedometerMoving = registry.func_94245_a("openblocks:pedometer_moving");
        this.pedometerStill = registry.func_94245_a("openblocks:pedometer_still");
    }

    private static void send(EntityPlayer player, String format, Object ... args) {
        player.func_146105_b((IChatComponent)new ChatComponentTranslation(format, args));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            if (player.func_70093_af()) {
                PedometerHandler.reset((Entity)player);
                ItemPedometer.send(player, "openblocks.misc.pedometer.tracking_reset", new Object[0]);
            } else {
                PedometerHandler.PedometerState state = PedometerHandler.getProperty((Entity)player);
                if (state.isRunning()) {
                    this.showPedometerData(player, state);
                } else {
                    state.init((Entity)player, world);
                    ItemPedometer.send(player, "openblocks.misc.pedometer.tracking_started", new Object[0]);
                }
            }
        } else {
            world.func_72956_a((Entity)player, "openblocks:pedometer.use", 1.0f, 1.0f);
        }
        return stack;
    }

    protected void showPedometerData(EntityPlayer player, PedometerHandler.PedometerState state) {
        PedometerHandler.PedometerData result = state.getData();
        if (result == null) {
            return;
        }
        player.func_146105_b((IChatComponent)new ChatComponentText(""));
        ItemPedometer.send(player, "openblocks.misc.pedometer.start_point", String.format("%.1f %.1f %.1f", result.startingPoint.field_72450_a, result.startingPoint.field_72448_b, result.startingPoint.field_72449_c));
        ItemPedometer.send(player, "openblocks.misc.pedometer.speed", this.speedUnit.format(result.currentSpeed));
        ItemPedometer.send(player, "openblocks.misc.pedometer.avg_speed", this.speedUnit.format(result.averageSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.total_distance", this.distanceUnit.format(result.totalDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.straght_line_distance", this.distanceUnit.format(result.straightLineDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.straigh_line_speed", this.speedUnit.format(result.straightLineSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_speed", this.speedUnit.format(result.lastCheckSpeed()));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_distance", this.distanceUnit.format(result.lastCheckDistance));
        ItemPedometer.send(player, "openblocks.misc.pedometer.last_check_time", result.lastCheckTime);
        ItemPedometer.send(player, "openblocks.misc.pedometer.total_time", result.totalTime);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (world.field_72995_K && slotId < 9) {
            PedometerHandler.updatePedometerData(entity);
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y > 0.01) {
            return this.pedometerMoving;
        }
        return this.pedometerStill;
    }
}

