/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.configuration.setting;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.configuration.setting.Setting;

public class IntegerSetting
extends Setting<Integer> {
    private UITextField textField;

    public IntegerSetting(String key, int defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public Integer readValue(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String writeValue(Integer value) {
        return value.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public UIComponent getComponent(MalisisGui gui) {
        UILabel label = new UILabel(gui, this.key);
        this.textField = (UITextField)new UITextField(gui, this.writeValue((Integer)this.value)).setSize(50, 0).setPosition(label.getWidth() + 2, 0);
        UIContainer container = new UIContainer(gui, label.getWidth() + 54, 12);
        container.add(label);
        container.add(this.textField);
        return container;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Integer getValueFromComponent() {
        return this.readValue(this.textField.getText());
    }
}

