/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.entity.SyncedObject;
import mcjty.lib.network.Argument;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.CommandHandler;
import mcjty.lib.varia.Coordinate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class GenericTileEntity
extends TileEntity
implements CommandHandler,
ClientCommandHandler {
    private List<SyncedObject> syncedObjects = new ArrayList<SyncedObject>();
    private int infused = 0;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;

    public void setInvalid() {
        int newMeta;
        for (SyncedObject value : this.syncedObjects) {
            value.setInvalid();
        }
        int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (oldMeta != (newMeta = this.updateMetaData(oldMeta))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    public void setPowered(int powered) {
    }

    protected void checkStateClient() {
        boolean syncNeeded = false;
        for (SyncedObject value : this.syncedObjects) {
            if (value.isClientValueUptodate()) continue;
            value.updateClientValue();
            syncNeeded = true;
        }
        if (syncNeeded) {
            this.notifyBlockUpdate();
        }
    }

    protected void checkStateServer() {
    }

    protected void notifyBlockUpdate() {
        int newMeta;
        int oldMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (oldMeta != (newMeta = this.updateMetaData(oldMeta))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected int updateMetaData(int meta) {
        return meta;
    }

    protected void registerSyncedObject(SyncedObject value) {
        this.syncedObjects.add(value);
    }

    public boolean canUpdate() {
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void setInfused(int infused) {
        this.infused = infused;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getInfused() {
        return this.infused;
    }

    public float getInfusedFactor() {
        return (float)this.infused / (float)GeneralConfig.maxInfuse;
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.func_145837_r() && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        this.infused = tagCompound.func_74762_e("infused");
        this.ownerName = tagCompound.func_74779_i("owner");
        this.ownerUUID = tagCompound.func_74764_b("idM") ? new UUID(tagCompound.func_74763_f("idM"), tagCompound.func_74763_f("idL")) : null;
        this.securityChannel = tagCompound.func_74764_b("secChannel") ? tagCompound.func_74762_e("secChannel") : -1;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeRestorableToNBT(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("infused", this.infused);
        tagCompound.func_74778_a("owner", this.ownerName);
        if (this.ownerUUID != null) {
            tagCompound.func_74772_a("idM", this.ownerUUID.getMostSignificantBits());
            tagCompound.func_74772_a("idL", this.ownerUUID.getLeastSignificantBits());
        }
        if (this.securityChannel != -1) {
            tagCompound.func_74768_a("secChannel", this.securityChannel);
        }
    }

    public boolean setOwner(EntityPlayer player) {
        if (!GeneralConfig.manageOwnership) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.func_146103_bH().getId();
        this.ownerName = player.getDisplayName();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public void clearOwner() {
        if (!GeneralConfig.manageOwnership) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        return false;
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        return false;
    }

    @Override
    public boolean execute(String command, Integer result) {
        return false;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

