/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.SoundEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public class SoundDetector {
    private static final int MAX_ENTITIES = 64;
    public static SoundDetector instance = new SoundDetector();
    private List<SoundSource> sounds;
    private ArrayBlockingQueue<SoundSource> soundQueue = new ArrayBlockingQueue(64);
    private Minecraft mc = Minecraft.func_71410_x();
    boolean enabled = false;
    double maxRangeSq = Config.darkSteelSoundLocatorRange * Config.darkSteelSoundLocatorRange;

    @SubscribeEvent
    public void onSound(PlaySoundAtEntityEvent evt) {
        if (this.enabled && evt.entity != null && evt.entity != Minecraft.func_71410_x().field_71439_g && this.soundQueue.size() < 64) {
            this.soundQueue.offer(new SoundSource(evt.entity, evt.volume));
        }
    }

    @SubscribeEvent
    public void onSound(PlaySoundSourceEvent evt) {
        if (this.enabled && this.soundQueue.size() < 64) {
            this.soundQueue.offer(new SoundSource(evt.sound.func_147649_g(), evt.sound.func_147654_h(), evt.sound.func_147651_i(), evt.sound.func_147653_e()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!this.enabled || this.mc.field_71439_g == null || this.mc.field_71439_g.field_70170_p == null) {
            return;
        }
        this.sounds = new ArrayList<SoundSource>(64);
        this.soundQueue.drainTo(this.sounds);
        try {
            Vector3d eye = Util.getEyePositionEio((EntityPlayer)this.mc.field_71439_g);
            for (SoundSource ss : this.sounds) {
                double distSq = ss.pos.distanceSquared(eye);
                int n = ss.isEntity ? 4 : 49;
                int minDist = n;
                if (!(distSq > (double)minDist) || !(distSq <= this.maxRangeSq)) continue;
                this.mc.field_71439_g.field_70170_p.func_72838_d((Entity)new SoundEntity(this.mc.field_71439_g.field_70170_p, ss.pos, ss.volume));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static class SoundSource {
        Vector3d pos;
        float volume;
        boolean isEntity;

        public SoundSource(Entity ent, float volume) {
            AxisAlignedBB bb = ent.field_70121_D;
            this.pos = bb != null ? new Vector3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) / 2.0, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) / 2.0, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) / 2.0) : new Vector3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
            this.volume = volume;
            this.isEntity = true;
        }

        public SoundSource(double x, double y, double z, float volume) {
            this.pos = new Vector3d(x, y, z);
            this.volume = volume;
            this.isEntity = false;
        }
    }
}

