/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityDish
extends TileBaseUniversalElectrical
implements IMultiBlock,
IPacketReceiver,
IDisableableMachine,
IInventory,
ISidedInventory,
IConnector {
    public float targetAngle;
    public float currentAngle;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    private ItemStack[] containingItems = new ItemStack[1];
    private boolean initialised = false;

    public TileEntityDish() {
        this.storage.setMaxExtract(100.0f);
        this.setTierGC(1);
        this.initialised = true;
    }

    @Override
    public void func_145845_h() {
        float difference;
        if (!this.initialised) {
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.disableCooldown > 0) {
            --this.disableCooldown;
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        if ((celestialAngle %= 360.0f) > 30.0f && celestialAngle < 150.0f) {
            difference = this.targetAngle - celestialAngle;
            this.targetAngle -= difference / 20.0f;
        } else if (!this.field_145850_b.func_72935_r() || this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) {
            this.targetAngle = 257.5f;
        } else if (celestialAngle < 50.0f) {
            this.targetAngle = 50.0f;
        } else if (celestialAngle > 150.0f) {
            this.targetAngle = 150.0f;
        }
        difference = this.targetAngle - this.currentAngle;
        this.currentAngle += difference / 20.0f;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return this.func_145838_q().func_149727_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer, 0, (float)this.field_145851_c, (float)this.field_145848_d, (float)this.field_145849_e);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void onCreate(BlockVec3 placedPosition) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        if (placedPosition.y + 1 > buildHeight) {
            return;
        }
        BlockVec3 vecStrut = new BlockVec3(placedPosition.x, placedPosition.y + 1, placedPosition.z);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecStrut, placedPosition, 0);
        if (placedPosition.y + 2 > buildHeight) {
            return;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockVec3 vecToAdd = new BlockVec3(placedPosition.x + x, placedPosition.y + 2, placedPosition.z + z);
                ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecToAdd, placedPosition, this.getTierGC() == 1 ? 4 : 0);
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        BlockVec3 thisBlock = new BlockVec3(this);
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                        FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(thisBlock.x + (y == 2 ? x : 0), thisBlock.y + y, thisBlock.z + (y == 2 ? z : 0), GCBlocks.radioTelescope, Block.func_149682_b((Block)GCBlocks.radioTelescope) >> 12 & 0xFF);
                    }
                    this.field_145850_b.func_147468_f(thisBlock.x + (y == 2 ? x : 0), thisBlock.y + y, thisBlock.z + (y == 2 ? z : 0));
                }
            }
        }
        this.field_145850_b.func_147480_a(thisBlock.x, thisBlock.y, thisBlock.z, true);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.currentAngle = nbt.func_74760_g("currentAngle");
        this.targetAngle = nbt.func_74760_g("targetAngle");
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.initialised = false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74776_a("currentAngle", this.currentAngle);
        nbt.func_74776_a("targetAngle", this.targetAngle);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return "";
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    @Override
    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }
}

