/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityAdvanced
extends TileEntity
implements IPacketReceiver {
    public long ticks = 0L;
    private LinkedHashSet<Field> fieldCacheClient;
    private LinkedHashSet<Field> fieldCacheServer;
    private Map<Field, Object> lastSentData = new HashMap<Field, Object>();
    private boolean networkDataChanged = false;

    public void func_145845_h() {
        if (this.ticks == 0L) {
            this.initiate();
        }
        ++this.ticks;
        if (this.isNetworkedTile() && this.ticks % (long)this.getPacketCooldown() == 0L) {
            if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
                try {
                    this.initFieldCache();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.field_145850_b.field_72995_K && this.fieldCacheServer.size() > 0) {
                PacketDynamic packet = new PacketDynamic(this);
                GalacticraftCore.packetPipeline.sendToServer(packet);
            } else if (!this.field_145850_b.field_72995_K && this.fieldCacheClient.size() > 0) {
                PacketDynamic packet = new PacketDynamic(this);
                GalacticraftCore.packetPipeline.sendToAllAround(packet, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.getPacketRange()));
            }
        }
    }

    private void initFieldCache() throws IllegalArgumentException, IllegalAccessException {
        this.fieldCacheClient = new LinkedHashSet();
        this.fieldCacheServer = new LinkedHashSet();
        for (Field field : this.getClass().getFields()) {
            if (!field.isAnnotationPresent(Annotations.NetworkedField.class)) continue;
            Annotations.NetworkedField f = field.getAnnotation(Annotations.NetworkedField.class);
            if (f.targetSide() == Side.CLIENT) {
                this.fieldCacheClient.add(field);
                continue;
            }
            this.fieldCacheServer.add(field);
        }
    }

    public abstract double getPacketRange();

    public abstract int getPacketCooldown();

    public abstract boolean isNetworkedTile();

    public void addExtraNetworkedData(List<Object> networkedList) {
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
    }

    public void initiate() {
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        LinkedHashSet<Field> fieldList = null;
        boolean changed = false;
        if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
            try {
                this.initFieldCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fieldList = this.field_145850_b.field_72995_K ? this.fieldCacheServer : this.fieldCacheClient;
        for (Field f : fieldList) {
            boolean fieldChanged = false;
            try {
                Object data = f.get(this);
                Object lastData = this.lastSentData.get(f);
                if (!NetworkUtil.fuzzyEquals(lastData, data)) {
                    fieldChanged = true;
                }
                sendData.add(data);
                if (fieldChanged) {
                    this.lastSentData.put(f, NetworkUtil.cloneNetworkedObject(data));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            changed |= fieldChanged;
        }
        if (changed) {
            this.addExtraNetworkedData(sendData);
        } else {
            ArrayList<Object> prevSendData = new ArrayList<Object>(sendData);
            this.addExtraNetworkedData(sendData);
            if (!prevSendData.equals(sendData)) {
                changed = true;
            }
        }
        this.networkDataChanged = changed;
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.fieldCacheClient == null || this.fieldCacheServer == null) {
            try {
                this.initFieldCache();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.field_145850_b.field_72995_K && this.fieldCacheClient.size() == 0) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.fieldCacheServer.size() == 0) {
            return;
        }
        LinkedHashSet<Field> fieldSet = null;
        fieldSet = this.field_145850_b.field_72995_K ? this.fieldCacheClient : this.fieldCacheServer;
        for (Field field : fieldSet) {
            try {
                Object obj = NetworkUtil.getFieldValueFromStream(field, buffer, this.field_145850_b);
                field.set(this, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.readExtraNetworkedData(buffer);
    }

    @Override
    public void handlePacketData(Side side, EntityPlayer player) {
    }
}

