/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines.world;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.utility.LogHelper;

public class MachineWorldChunkloadCallback
implements ForgeChunkManager.LoadingCallback {
    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (ConfigurationHandler.chunkLoadingMode == 0) {
            LogHelper.info("Chunkloading is disabled. Skipping...");
            return;
        }
        if (ConfigurationHandler.chunkLoadingMode == 2) {
            LogHelper.info("Chunkloading is in smart mode. Releasing previously requested tickets...");
            for (ForgeChunkManager.Ticket ticket : tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            return;
        }
        LogHelper.info("Chunkloading is in always mode. Loading all previously loaded chunks.");
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int[] nbtCoords = data.func_74759_k("coords");
            boolean foundMatch = false;
            for (int i = 0; i < nbtCoords.length; ++i) {
                if (nbtCoords[i] == -1) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(nbtCoords[i] * ConfigurationHandler.cubeDistance >> 4, 0));
            }
            if (foundMatch) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }
}

