/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines.tools;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.machines.MachineSaveData;
import org.dave.CompactMachines.machines.tools.CubeTools;
import org.dave.CompactMachines.machines.world.TeleporterCM;
import org.dave.CompactMachines.network.MessagePlayerRotation;
import org.dave.CompactMachines.network.PacketHandler;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.dave.CompactMachines.utility.PlayerUtils;

public class TeleportTools {
    public static void teleportPlayerToCoords(EntityPlayerMP player, int coord, boolean isReturning) {
        double[] bestSpot;
        int dstZ;
        int dstY;
        int dstX;
        NBTTagCompound cmNBT;
        NBTTagCompound playerNBT = player.getEntityData();
        if (playerNBT.func_74764_b("CompactMachines")) {
            cmNBT = playerNBT.func_74775_l("CompactMachines");
        } else {
            cmNBT = new NBTTagCompound();
            playerNBT.func_74782_a("CompactMachines", (NBTBase)cmNBT);
        }
        if (player.field_71093_bK != ConfigurationHandler.dimensionId) {
            cmNBT.func_74768_a("oldDimension", player.field_71093_bK);
            cmNBT.func_74780_a("oldPosX", player.field_70165_t);
            cmNBT.func_74780_a("oldPosY", player.field_70163_u);
            cmNBT.func_74780_a("oldPosZ", player.field_70161_v);
            int oldDimension = player.field_71093_bK;
            WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, ConfigurationHandler.dimensionId, (Teleporter)new TeleporterCM(machineWorld));
            if (oldDimension == 1) {
                machineWorld.func_72838_d((Entity)player);
            }
            if (playerNBT.func_74764_b("coordHistory")) {
                playerNBT.func_82580_o("coordHistory");
            }
        }
        if (!isReturning) {
            NBTTagList coordHistory = playerNBT.func_74764_b("coordHistory") ? playerNBT.func_150295_c("coordHistory", 10) : new NBTTagList();
            NBTTagCompound toAppend = new NBTTagCompound();
            toAppend.func_74768_a("coord", coord);
            coordHistory.func_74742_a((NBTBase)toAppend);
            playerNBT.func_74782_a("coordHistory", (NBTBase)coordHistory);
        }
        MachineSaveData mHandler = CompactMachines.instance.machineHandler;
        double[] destination = mHandler.getSpawnLocation(coord);
        WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
        if (!(machineWorld.func_147437_c(dstX = (int)Math.floor(destination[0]), dstY = (int)Math.floor(destination[1]), dstZ = (int)Math.floor(destination[2])) && machineWorld.func_147437_c(dstX, dstY + 1, dstZ) || (bestSpot = TeleportTools.findBestSpawnLocation(machineWorld, coord)) == null)) {
            destination = bestSpot;
        }
        player.func_70634_a(destination[0], destination[1], destination[2]);
        if (destination.length == 5) {
            MessagePlayerRotation packet = new MessagePlayerRotation((float)destination[3], (float)destination[4]);
            PacketHandler.INSTANCE.sendTo((IMessage)packet, player);
        }
    }

    public static void teleportPlayerToMachineWorld(EntityPlayerMP player, TileEntityMachine machine) {
        int coords = CompactMachines.instance.machineHandler.createOrGetChunk(machine);
        TeleportTools.teleportPlayerToCoords(player, coords, false);
    }

    public static void teleportPlayerOutOfMachineDimension(EntityPlayerMP player) {
        double targetZ;
        double targetY;
        double targetX;
        NBTTagCompound playerNBT = player.getEntityData();
        NBTTagCompound cmNBT = null;
        if (playerNBT.func_74764_b("CompactMachines")) {
            cmNBT = playerNBT.func_74775_l("CompactMachines");
        }
        int targetDimension = 0;
        if (cmNBT != null && cmNBT.func_74764_b("oldPosX")) {
            targetDimension = cmNBT.func_74762_e("oldDimension");
            targetX = cmNBT.func_74769_h("oldPosX");
            targetY = cmNBT.func_74769_h("oldPosY");
            targetZ = cmNBT.func_74769_h("oldPosZ");
        } else if (playerNBT.func_74764_b("oldDimension") && playerNBT.func_74762_e("oldDimension") != ConfigurationHandler.dimensionId) {
            targetDimension = playerNBT.func_74762_e("oldDimension");
            targetX = playerNBT.func_74769_h("oldPosX");
            targetY = playerNBT.func_74769_h("oldPosY");
            targetZ = playerNBT.func_74769_h("oldPosZ");
        } else {
            ChunkCoordinates cc = MinecraftServer.func_71276_C().func_71218_a((int)0).field_73011_w.getRandomizedSpawnPoint();
            targetX = cc.field_71574_a;
            targetY = cc.field_71572_b;
            targetZ = cc.field_71573_c;
        }
        MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, targetDimension, (Teleporter)new TeleporterCM(MinecraftServer.func_71276_C().func_71218_a(targetDimension)));
        player.func_70634_a(targetX, targetY, targetZ);
    }

    public static void teleportPlayerBack(EntityPlayerMP player) {
        NBTTagCompound playerNBT = player.getEntityData();
        if (playerNBT.func_74764_b("coordHistory")) {
            NBTTagList coordHistory = playerNBT.func_150295_c("coordHistory", 10);
            if (coordHistory.func_74745_c() == 0) {
                TeleportTools.teleportPlayerOutOfMachineDimension(player);
            } else {
                coordHistory.func_74744_a(coordHistory.func_74745_c() - 1);
                if (coordHistory.func_74745_c() == 0) {
                    TeleportTools.teleportPlayerOutOfMachineDimension(player);
                    return;
                }
                int coord = coordHistory.func_150305_b(coordHistory.func_74745_c() - 1).func_74762_e("coord");
                TeleportTools.teleportPlayerToCoords(player, coord, true);
            }
        } else {
            TeleportTools.teleportPlayerOutOfMachineDimension(player);
        }
    }

    private static double[] findBestSpawnLocation(WorldServer machineWorld, int coord) {
        int size = Reference.getBoxSize(CompactMachines.instance.machineHandler.getRoomSize(coord));
        int posX1 = coord * ConfigurationHandler.cubeDistance + 1;
        int posY1 = 41;
        int posZ1 = 1;
        int posX2 = coord * ConfigurationHandler.cubeDistance + size - 1;
        int posY2 = 40 + size - 1;
        int posZ2 = size - 1;
        int minX = Math.min(posX1, posX2);
        int minY = Math.min(posY1, posY2);
        int minZ = Math.min(posZ1, posZ2);
        int maxX = Math.max(posX1, posX2);
        int maxY = Math.max(posY1, posY2) - 1;
        int maxZ = Math.max(posZ1, posZ2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!machineWorld.func_147437_c(x, y, z) || !machineWorld.func_147437_c(x, y + 1, z)) continue;
                    return new double[]{(double)x + 0.5, (double)y + 0.5, (double)z + 0.5};
                }
            }
        }
        return null;
    }

    public static void checkPlayerPositions() {
        World worldObj = CompactMachines.instance.machineHandler.getWorld();
        if (worldObj.func_82737_E() % 10L == 0L) {
            for (int i = 0; i < worldObj.field_73010_i.size(); ++i) {
                int roomSize;
                AxisAlignedBB bb;
                int lastCoord;
                if (!(worldObj.field_73010_i.get(i) instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)worldObj.field_73010_i.get(i);
                if (player.field_70163_u < 10.0) {
                    player.field_70143_R = 0.0f;
                    TeleportTools.teleportPlayerOutOfMachineDimension((EntityPlayerMP)player);
                    continue;
                }
                if (!ConfigurationHandler.keepPlayersInsideOfRooms || player.field_71075_bZ.field_75098_d && PlayerUtils.isPlayerOpped(player) || (lastCoord = PlayerUtils.getPlayerCoords(player)) == -1 || !CompactMachines.instance.machineHandler.hasRoomSize(lastCoord) || (bb = CubeTools.getBoundingBoxForCube(lastCoord, roomSize = Reference.getBoxSize(CompactMachines.instance.machineHandler.getRoomSize(lastCoord)))).func_72318_a(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) continue;
                TeleportTools.teleportPlayerToCoords((EntityPlayerMP)player, lastCoord, true);
                player.func_70690_d(new PotionEffect(2, 200, 5, false));
                player.func_70690_d(new PotionEffect(9, 200, 5, false));
            }
        }
    }
}

