/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.thaumcraft;

import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;

@Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="Thaumcraft")
public class ThaumcraftSharedStorage
extends AbstractHoppingStorage
implements IEssentiaTransport {
    private static Map<String, Integer> aspectToID = new HashMap<String, Integer>();
    private static Map<Integer, String> idToAspect = new HashMap<Integer, String>();
    protected Aspect aspect;
    protected int aspectAmount;

    public ThaumcraftSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.max_cooldown = ConfigurationHandler.cooldownEssentia;
        this.side = side;
        this.coord = coord;
        super.setHoppingMode(4);
        if (aspectToID.isEmpty()) {
            ArrayList<String> aspectNames = new ArrayList<String>();
            for (Aspect aspect : Aspect.aspects.values()) {
                aspectNames.add(aspect.getTag());
            }
            Collections.sort(aspectNames);
            int id = 0;
            for (String aspect : aspectNames) {
                aspectToID.put(aspect, id);
                idToAspect.put(id++, aspect);
            }
        }
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.aspect != null) {
            compound.func_74778_a("Aspect", this.aspect.getTag());
            compound.func_74768_a("AspectAmount", this.aspectAmount);
        }
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.aspect = Aspect.getAspect((String)tag.func_74779_i("Aspect"));
        this.aspectAmount = tag.func_74762_e("AspectAmount");
    }

    @Override
    public String type() {
        return "thaumcraft";
    }

    @Override
    public void setHoppingMode(int mode) {
    }

    public boolean isConnectable(ForgeDirection face) {
        return ConfigurationHandler.enableIntegrationThaumcraft;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return ConfigurationHandler.enableIntegrationThaumcraft;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return ConfigurationHandler.enableIntegrationThaumcraft;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return null;
        }
        return this.aspect == null ? null : this.aspect;
    }

    public int getSuctionAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return ConfigurationHandler.capacityEssentia >= this.aspectAmount ? 48 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (ConfigurationHandler.enableIntegrationThaumcraft && (aspect == null || aspect == this.aspect) && amount <= this.aspectAmount) {
            this.aspectAmount -= amount;
            if (this.aspectAmount <= 0) {
                this.aspect = null;
                this.aspectAmount = 0;
            }
            this.setDirty();
            return amount;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (ConfigurationHandler.enableIntegrationThaumcraft && (this.aspect == null || aspect == this.aspect)) {
            this.aspect = aspect;
            int amountToAdd = Math.min(amount, ConfigurationHandler.capacityEssentia - this.aspectAmount);
            this.aspectAmount += amountToAdd;
            this.setDirty();
            return amountToAdd;
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return null;
        }
        return this.aspect;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return 0;
        }
        return this.aspectAmount;
    }

    public int getMinimumSuction() {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return Integer.MAX_VALUE;
        }
        return 48;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    @Override
    public void hopToTileEntity(TileEntity target, boolean useOppositeSide) {
        if (!ConfigurationHandler.enableIntegrationThaumcraft) {
            return;
        }
        if (this.aspectAmount >= ConfigurationHandler.capacityEssentia || !(target instanceof IEssentiaTransport)) {
            return;
        }
        IEssentiaTransport et = (IEssentiaTransport)target;
        ForgeDirection hoppingSide = ForgeDirection.getOrientation((int)this.side);
        if (useOppositeSide) {
            hoppingSide = hoppingSide.getOpposite();
        }
        if (et.isConnectable(hoppingSide.getOpposite()) && et.canOutputTo(hoppingSide.getOpposite())) {
            Aspect ta = null;
            if (this.aspect != null && this.aspectAmount > 0) {
                ta = this.aspect;
            } else if (et.getEssentiaAmount(hoppingSide.getOpposite()) > 0 && et.getSuctionAmount(hoppingSide.getOpposite()) < this.getSuctionAmount(hoppingSide) && this.getSuctionAmount(hoppingSide) >= et.getMinimumSuction()) {
                ta = et.getEssentiaType(hoppingSide.getOpposite());
            }
            if (ta != null && et.getSuctionAmount(hoppingSide.getOpposite()) < this.getSuctionAmount(hoppingSide)) {
                this.addEssentia(ta, et.takeEssentia(ta, 1, hoppingSide.getOpposite()), hoppingSide);
            }
        }
    }

    public static int getIDForAspect(Aspect aspect) {
        return aspectToID.get(aspect.getTag());
    }

    public static Aspect getAspectForID(int ID) {
        return Aspect.getAspect((String)idToAspect.get(ID));
    }
}

