/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.redstoneflux;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;

public class FluxSharedStorage
extends AbstractHoppingStorage
implements IEnergyStorage {
    protected int energy = 0;

    public FluxSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.max_cooldown = ConfigurationHandler.cooldownRF;
    }

    @Override
    public String type() {
        return "flux";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = super.saveToTag();
        compound.func_74768_a("Energy", this.energy);
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        super.loadFromTag(tag);
        this.energy = tag.func_74762_e("Energy");
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(ConfigurationHandler.capacityRF - this.energy, Math.min(ConfigurationHandler.capacityRF, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.setDirty();
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(ConfigurationHandler.capacityRF, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.setDirty();
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return ConfigurationHandler.capacityRF;
    }

    @Override
    public void hopToTileEntity(TileEntity tileEntity, boolean opposite) {
        if (this.getEnergyStored() == 0) {
            return;
        }
        if (tileEntity instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)tileEntity;
            int filled = storage.receiveEnergy(this.getEnergyStored(), false);
            if (filled > 0) {
                this.extractEnergy(filled, false);
                tileEntity.func_70296_d();
            }
        } else if (tileEntity instanceof IEnergyHandler) {
            int filled;
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            ForgeDirection hoppingSide = ForgeDirection.getOrientation((int)this.side);
            if (opposite) {
                hoppingSide = hoppingSide.getOpposite();
            }
            if ((filled = handler.receiveEnergy(hoppingSide, this.getEnergyStored(), false)) > 0) {
                this.extractEnergy(filled, false);
                tileEntity.func_70296_d();
            }
        }
    }
}

