/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.pneumaticcraft;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractBufferedStorage;
import pneumaticCraft.api.tileentity.AirHandlerSupplier;
import pneumaticCraft.api.tileentity.IAirHandler;
import pneumaticCraft.api.tileentity.IPneumaticMachine;
import pneumaticCraft.api.tileentity.ISidedPneumaticMachine;

public class PneumaticCraftSharedStorage
extends AbstractBufferedStorage {
    public int coord;
    public int side;
    private IAirHandler interfaceAirHandler;
    private boolean interfaceValid = false;
    private Map<Integer, IAirHandler> connectedHandlers = new HashMap<Integer, IAirHandler>();

    public PneumaticCraftSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.side = side;
        this.coord = coord;
        this.interfaceAirHandler = AirHandlerSupplier.getAirHandler((float)30.0f, (float)50.0f, (int)1000);
    }

    @Override
    public String type() {
        return "PneumaticCraft";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound tag = new NBTTagCompound();
        this.interfaceAirHandler.writeToNBTI(tag);
        return tag;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        if (tag.func_82582_d()) {
            return;
        }
        this.interfaceAirHandler.readFromNBTI(tag);
    }

    public void validateInterfaceAirHandler(TileEntity tile) {
        if (tile == null || tile.func_145831_w() == null) {
            return;
        }
        this.interfaceAirHandler.validateI(tile);
        this.interfaceValid = true;
        this.connectAll();
        this.setDirty();
    }

    public void invalidateInterfaceAirHandler() {
        this.disconnectAll();
        this.interfaceValid = false;
    }

    public IAirHandler getInterfaceAirHandler() {
        if (!this.isInterfaceValid()) {
            return null;
        }
        this.setDirty();
        return this.interfaceAirHandler;
    }

    public boolean isInterfaceValid() {
        return this.interfaceValid;
    }

    public Object createDummyAirHandler(TileEntity tile) {
        if (tile == null || tile.func_145831_w() == null) {
            return null;
        }
        IAirHandler dummyAirHandler = AirHandlerSupplier.getAirHandler((float)30.0f, (float)50.0f, (int)1);
        dummyAirHandler.validateI(tile);
        return dummyAirHandler;
    }

    public void connectAirHandler(int entangledInstance, TileEntity tile) {
        IAirHandler newHandler;
        if (tile == null || tile.func_145831_w() == null) {
            return;
        }
        IAirHandler existHandler = this.connectedHandlers.get(entangledInstance);
        if (existHandler != (newHandler = this.getHandlerFromTile(tile))) {
            this.removeAirHandler(entangledInstance);
            if (newHandler != null) {
                this.connectedHandlers.put(entangledInstance, newHandler);
                if (this.isInterfaceValid()) {
                    this.interfaceAirHandler.createConnection(newHandler);
                }
            }
        }
    }

    public void removeAirHandler(int entangledInstance) {
        if (this.connectedHandlers.containsKey(entangledInstance)) {
            if (this.isInterfaceValid()) {
                this.interfaceAirHandler.removeConnection(this.connectedHandlers.get(entangledInstance));
            }
            this.connectedHandlers.remove(entangledInstance);
        }
    }

    private IAirHandler getHandlerFromTile(TileEntity tile) {
        IAirHandler handler = null;
        if (tile instanceof IPneumaticMachine && ((IPneumaticMachine)tile).isConnectedTo(ForgeDirection.getOrientation((int)this.side).getOpposite())) {
            handler = ((IPneumaticMachine)tile).getAirHandler();
        } else if (tile instanceof ISidedPneumaticMachine) {
            handler = ((ISidedPneumaticMachine)tile).getAirHandler(ForgeDirection.getOrientation((int)this.side).getOpposite());
        }
        return handler;
    }

    private void connectAll() {
        if (this.isInterfaceValid()) {
            for (IAirHandler handler : this.connectedHandlers.values()) {
                this.interfaceAirHandler.createConnection(handler);
            }
        }
    }

    private void disconnectAll() {
        if (this.isInterfaceValid()) {
            for (IAirHandler handler : this.connectedHandlers.values()) {
                this.interfaceAirHandler.removeConnection(handler);
            }
        }
        this.connectedHandlers.clear();
    }
}

