/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.fluid;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.integration.fluid.ExtendedFluidTank;

public class FluidSharedStorage
extends AbstractHoppingStorage
implements IFluidHandler {
    private Tank tank = new Tank();

    public FluidSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.max_cooldown = ConfigurationHandler.cooldownFluid;
    }

    @Override
    public String type() {
        return "liquid";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = super.saveToTag();
        compound.func_74782_a("tank", (NBTBase)this.tank.toTag());
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        super.loadFromTag(tag);
        this.tank.fromTag(tag.func_74775_l("tank"));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void hopToTileEntity(TileEntity tileEntity, boolean opposite) {
        FluidStack stack = this.getFluid().copy();
        if (stack == null || stack.amount == 0) {
            return;
        }
        if (tileEntity instanceof IFluidHandler) {
            int filled;
            IFluidHandler fh = (IFluidHandler)tileEntity;
            ForgeDirection hoppingSide = ForgeDirection.getOrientation((int)this.side);
            if (opposite) {
                hoppingSide = hoppingSide.getOpposite();
            }
            if (fh.canFill(hoppingSide, stack.getFluid()) && (filled = fh.fill(hoppingSide, stack, false)) > 0) {
                fh.fill(hoppingSide, stack, true);
                this.drain(ForgeDirection.UNKNOWN, filled, true);
                tileEntity.func_70296_d();
            }
        }
    }

    private class Tank
    extends ExtendedFluidTank {
        @Override
        public void onLiquidChanged() {
            FluidSharedStorage.this.setDirty();
        }
    }
}

