/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.bundledredstone;

import net.minecraft.nbt.NBTTagCompound;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractBufferedStorage;

public class BRSharedStorage
extends AbstractBufferedStorage {
    public int coord;
    public int side;
    public boolean machineNeedsNotify = false;
    public byte[] machineBundledSignal = new byte[16];
    public byte[] machineOutputtedSignal = new byte[16];
    public byte[] interfaceBundledSignal = new byte[16];
    public byte[] interfaceOutputtedSignal = new byte[16];

    public BRSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        this.side = side;
        this.coord = coord;
    }

    @Override
    public String type() {
        return "bundledRedstone";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74773_a("machineBundledSignal", this.machineBundledSignal);
        compound.func_74773_a("machineOutputtedSignal", this.machineOutputtedSignal);
        compound.func_74773_a("interfaceBundledSignal", this.interfaceBundledSignal);
        compound.func_74773_a("interfaceOutputtedSignal", this.interfaceOutputtedSignal);
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.machineBundledSignal = tag.func_74770_j("machineBundledSignal");
        this.machineOutputtedSignal = tag.func_74770_j("machineOutputtedSignal");
        this.interfaceBundledSignal = tag.func_74770_j("interfaceBundledSignal");
        this.interfaceOutputtedSignal = tag.func_74770_j("interfaceOutputtedSignal");
        if (this.machineBundledSignal == null || this.machineBundledSignal.length < 16) {
            this.machineBundledSignal = new byte[16];
        }
        if (this.machineOutputtedSignal == null || this.machineOutputtedSignal.length < 16) {
            this.machineOutputtedSignal = new byte[16];
        }
        if (this.interfaceBundledSignal == null || this.interfaceBundledSignal.length < 16) {
            this.interfaceBundledSignal = new byte[16];
        }
        if (this.interfaceOutputtedSignal == null || this.interfaceOutputtedSignal.length < 16) {
            this.interfaceOutputtedSignal = new byte[16];
        }
    }

    private static String getByteString(byte[] arr) {
        String resString = "[";
        for (int i = 0; i < arr.length; ++i) {
            resString = resString + (arr[i] & 0xFF) + ",";
        }
        return resString.substring(0, resString.length() - 1) + "]";
    }
}

