/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractBufferedStorage;

public abstract class AbstractHoppingStorage
extends AbstractBufferedStorage {
    private int hoppingMode = 0;
    private boolean autoHopToInside = false;
    protected int max_cooldown = 20;
    private int cooldown = 0;

    public AbstractHoppingStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
    }

    public int getHoppingMode() {
        return this.hoppingMode;
    }

    public void setHoppingMode(int mode) {
        this.hoppingMode = mode;
    }

    public boolean isAutoHoppingToInside() {
        return this.autoHopToInside;
    }

    public void setAutoHoppingToInside(boolean state) {
        this.autoHopToInside = state;
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("hoppingMode", this.hoppingMode);
        compound.func_74757_a("autoToInside", this.autoHopToInside);
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.hoppingMode = tag.func_74762_e("hoppingMode");
        this.autoHopToInside = tag.func_74767_n("autoToInside");
    }

    public void hoppingTick(TileEntity target, boolean useOppositeSide) {
        if (this.cooldown != this.max_cooldown) {
            ++this.cooldown;
            return;
        }
        this.cooldown = 0;
        this.hopToTileEntity(target, useOppositeSide);
    }

    public abstract void hopToTileEntity(TileEntity var1, boolean var2);
}

