/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.Engines.ModuleEngine;

public class ModulePowerObserver
extends ModuleAddon {
    private short[] areaData = new short[4];
    private short[] powerLevel = new short[4];
    private int currentEngine = -1;

    public ModulePowerObserver(MinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int guiWidth() {
        return 190;
    }

    @Override
    public int guiHeight() {
        return 150;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
        for (int i = 0; i < 4; ++i) {
            int[] rect = this.getPowerRect(i);
            this.drawString(gui, this.powerLevel[i] + Localization.MODULES.ADDONS.K.translate(new String[0]), rect, 0x404040);
        }
    }

    private boolean removeOnPickup() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        int i;
        for (i = 0; i < this.getCart().getEngines().size(); ++i) {
            if (this.removeOnPickup() && this.currentEngine == i) continue;
            this.drawEngine(gui, i, this.getEngineRect(i));
        }
        ResourceHelper.bindResource("/gui/observer.png");
        for (i = 0; i < 4; ++i) {
            int[] rect = this.getAreaRect(i);
            this.drawImage(gui, rect, 18, 22 * i);
            if (this.inRect(x, y, rect)) {
                this.drawImage(gui, rect, 18, 22 * (i + 4));
            }
            int count = 0;
            for (int j = 0; j < this.getCart().getEngines().size(); ++j) {
                if ((this.areaData[i] & 1 << j) == 0) continue;
                this.drawEngine(gui, j, this.getEngineRectInArea(i, count));
                ++count;
            }
            ResourceHelper.bindResource("/gui/observer.png");
            rect = this.getPowerRect(i);
            if (this.isAreaActive(i)) {
                this.drawImage(gui, rect, 122, 0);
            } else {
                this.drawImage(gui, rect, 122 + rect[2], 0);
            }
            if (!this.inRect(x, y, rect)) continue;
            this.drawImage(gui, rect, 122 + rect[2] * 2, 0);
        }
        if (this.currentEngine != -1) {
            this.drawEngine(gui, this.currentEngine, this.getEngineRectMouse(x, y + this.getCart().getRealScrollY()));
        }
    }

    private void drawEngine(GuiMinecart gui, int id, int[] rect) {
        ModuleEngine engine = this.getCart().getEngines().get(id);
        ResourceHelper.bindResourcePath("/atlas/items.png");
        this.drawImage(gui, engine.getData().getIcon(), rect, 0, 0);
    }

    private int[] getAreaRect(int id) {
        return new int[]{10, 40 + 25 * id, 104, 22};
    }

    private int[] getEngineRect(int id) {
        return new int[]{11 + id * 20, 21, 16, 16};
    }

    private int[] getEngineRectMouse(int x, int y) {
        return new int[]{x - 8, y - 8, 16, 16};
    }

    private int[] getEngineRectInArea(int areaid, int number) {
        int[] area = this.getAreaRect(areaid);
        return new int[]{area[0] + 4 + number * 20, area[1] + 3, 16, 16};
    }

    private int[] getPowerRect(int areaid) {
        int[] area = this.getAreaRect(areaid);
        return new int[]{area[0] + area[2] + 10, area[1] + 2, 35, 18};
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        int i;
        for (i = 0; i < this.getCart().getEngines().size(); ++i) {
            if (this.removeOnPickup() && this.currentEngine == i) continue;
            ModuleEngine engine = this.getCart().getEngines().get(i);
            this.drawStringOnMouseOver(gui, engine.getData().getName() + "\n" + Localization.MODULES.ADDONS.OBSERVER_INSTRUCTION.translate(new String[0]), x, y, this.getEngineRect(i));
        }
        for (i = 0; i < 4; ++i) {
            int count = 0;
            for (int j = 0; j < this.getCart().getEngines().size(); ++j) {
                if ((this.areaData[i] & 1 << j) == 0) continue;
                ModuleEngine engine = this.getCart().getEngines().get(j);
                this.drawStringOnMouseOver(gui, engine.getData().getName() + "\n" + Localization.MODULES.ADDONS.OBSERVER_REMOVE.translate(new String[0]), x, y, this.getEngineRectInArea(i, count));
                ++count;
            }
            if (this.currentEngine != -1) {
                this.drawStringOnMouseOver(gui, Localization.MODULES.ADDONS.OBSERVER_DROP.translate(new String[0]), x, y, this.getAreaRect(i));
            }
            this.drawStringOnMouseOver(gui, Localization.MODULES.ADDONS.OBSERVER_CHANGE.translate(new String[0]) + "\n" + Localization.MODULES.ADDONS.OBSERVER_CHANGE_10.translate(new String[0]), x, y, this.getPowerRect(i));
        }
    }

    @Override
    public int numberOfGuiData() {
        return 8;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.updateGuiData(info, i, this.areaData[i]);
        }
        for (i = 0; i < 4; ++i) {
            this.updateGuiData(info, i + 4, this.powerLevel[i]);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id >= 0 && id < 4) {
            this.areaData[id] = data;
        } else if (id >= 4 && id < 8) {
            this.powerLevel[id - 4] = data;
        }
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte area = data[0];
            byte engine = data[1];
            byte by = area;
            this.areaData[by] = (short)(this.areaData[by] | 1 << engine);
        } else if (id == 1) {
            byte area = data[0];
            byte engine = data[1];
            byte by = area;
            this.areaData[by] = (short)(this.areaData[by] & ~(1 << engine));
        } else if (id == 2) {
            int change;
            byte area = data[0];
            int button = data[1] & 1;
            boolean shift = (data[1] & 2) != 0;
            int n = change = button == 0 ? 1 : -1;
            if (shift) {
                change *= 10;
            }
            int value = this.powerLevel[area];
            if ((value = (short)(value + change)) < 0) {
                value = 0;
            } else if (value > 999) {
                value = 999;
            }
            this.powerLevel[area] = value;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (button != -1) {
            if (button == 0) {
                for (int i = 0; i < 4; ++i) {
                    int[] rect = this.getAreaRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.sendPacket(0, new byte[]{(byte)i, (byte)this.currentEngine});
                    break;
                }
            }
            this.currentEngine = -1;
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        block5: {
            int i;
            block6: {
                int[] rect;
                for (i = 0; i < 4; ++i) {
                    rect = this.getPowerRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.sendPacket(2, new byte[]{(byte)i, (byte)(button | (GuiScreen.func_146272_n() ? 2 : 0))});
                    break;
                }
                if (button != 0) break block6;
                for (i = 0; i < this.getCart().getEngines().size(); ++i) {
                    rect = this.getEngineRect(i);
                    if (!this.inRect(x, y, rect)) continue;
                    this.currentEngine = i;
                    break block5;
                }
                break block5;
            }
            if (button != 1) break block5;
            block2: for (i = 0; i < 4; ++i) {
                int count = 0;
                for (int j = 0; j < this.getCart().getEngines().size(); ++j) {
                    if ((this.areaData[i] & 1 << j) == 0) continue;
                    int[] rect = this.getEngineRectInArea(i, count);
                    if (this.inRect(x, y, rect)) {
                        this.sendPacket(1, new byte[]{(byte)i, (byte)j});
                        continue block2;
                    }
                    ++count;
                }
            }
        }
    }

    public boolean isAreaActive(int area) {
        int power = 0;
        for (int i = 0; i < this.getCart().getEngines().size(); ++i) {
            ModuleEngine engine = this.getCart().getEngines().get(i);
            if ((this.areaData[area] & 1 << i) == 0) continue;
            power += engine.getTotalFuel();
        }
        return power > this.powerLevel[area] * 1000;
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        for (int i = 0; i < 4; ++i) {
            tagCompound.func_74777_a(this.generateNBTName("AreaData" + i, id), this.areaData[i]);
            tagCompound.func_74777_a(this.generateNBTName("PowerLevel" + i, id), this.powerLevel[i]);
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        for (int i = 0; i < 4; ++i) {
            this.areaData[i] = tagCompound.func_74765_d(this.generateNBTName("AreaData" + i, id));
            this.powerLevel[i] = tagCompound.func_74765_d(this.generateNBTName("PowerLevel" + i, id));
        }
    }
}

