/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.audio;

import java.util.HashMap;
import pl.asie.lib.audio.StreamingAudioPlayer;

public abstract class StreamingPlaybackManager {
    private final boolean isClient;
    private int currentId = 0;
    private HashMap<Integer, StreamingAudioPlayer> players = new HashMap();

    public StreamingPlaybackManager(boolean isClient) {
        this.isClient = isClient;
    }

    public abstract StreamingAudioPlayer create();

    public int newPlayer() {
        StreamingAudioPlayer codec = this.create();
        this.players.put(this.currentId++, codec);
        return this.currentId - 1;
    }

    public void removePlayer(int id) {
        if (this.players.containsKey(id)) {
            if (this.isClient) {
                this.players.get(id).stop();
            }
            this.players.remove(id);
        }
    }

    public StreamingAudioPlayer getPlayer(int id) {
        if (!this.players.containsKey(id)) {
            this.players.put(id, this.create());
        }
        return this.players.get(id);
    }

    public void removeAll() {
        for (int id : this.players.keySet()) {
            this.players.get(id).stop();
        }
        this.players.clear();
    }
}

