/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.audio.DFPWM;

public class StreamingAudioPlayer
extends DFPWM {
    private final Set<SourceEntry> sources = new HashSet<SourceEntry>();
    private final ArrayList<IntBuffer> buffersPlayed = new ArrayList();
    private final int BUFFER_PACKETS;
    private final int AUDIO_FORMAT;
    private IntBuffer currentBuffer;
    private int sampleRate = 32768;
    private float volume = 1.0f;
    private float distance = 24.0f;

    public StreamingAudioPlayer(boolean sixteenBit, boolean stereo, int bufferPackets) {
        this.BUFFER_PACKETS = bufferPackets;
        this.AUDIO_FORMAT = sixteenBit ? (stereo ? 4355 : 4353) : (stereo ? 4354 : 4352);
        this.reset();
    }

    public void setHearing(float dist, float vol) {
        this.distance = dist;
        this.volume = vol;
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
    }

    public void reset() {
        this.buffersPlayed.clear();
        this.stop();
    }

    @SideOnly(value=Side.CLIENT)
    private double getDistance(int x, int y, int z) {
        Vec3 pos = Minecraft.func_71410_x().field_71439_g.func_70666_h(1.0f);
        return pos.func_72438_d(Vec3.func_72443_a((double)x, (double)y, (double)z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(byte[] data) {
        if (this.currentBuffer == null) {
            this.currentBuffer = BufferUtils.createIntBuffer((int)1);
        } else {
            for (SourceEntry source : this.sources) {
                int processed = AL10.alGetSourcei((int)source.src.get(0), (int)4118);
                if (processed <= 0) continue;
                AL10.alSourceUnqueueBuffers((int)source.src.get(0), (IntBuffer)this.currentBuffer);
            }
        }
        AL10.alGenBuffers((IntBuffer)this.currentBuffer);
        AL10.alBufferData((int)this.currentBuffer.get(0), (int)this.AUDIO_FORMAT, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)data.length).put(data).flip()), (int)this.sampleRate);
        ArrayList<IntBuffer> arrayList = this.buffersPlayed;
        synchronized (arrayList) {
            this.buffersPlayed.add(this.currentBuffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void play(int x, int y, int z) {
        float distanceUsed;
        float playerDistance;
        float distanceReal;
        float gain;
        FloatBuffer sourcePos = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{x, y, z}).rewind();
        FloatBuffer sourceVel = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f}).rewind();
        SourceEntry source = null;
        for (SourceEntry entry : this.sources) {
            if (entry.x != x || entry.y != y || entry.z != z) continue;
            source = entry;
        }
        if (source == null) {
            source = new SourceEntry(x, y, z);
            this.sources.add(source);
        }
        if ((gain = (distanceReal = 1.0f - (playerDistance = (float)this.getDistance(x, y, z)) / (distanceUsed = this.distance * (0.2f + this.volume * 0.8f))) * this.volume * Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.RECORDS)) < 0.0f) {
            gain = 0.0f;
        } else if (gain > 1.0f) {
            gain = 1.0f;
        }
        AL10.alSourcei((int)source.src.get(0), (int)4103, (int)0);
        AL10.alSourcef((int)source.src.get(0), (int)4099, (float)1.0f);
        AL10.alSourcef((int)source.src.get(0), (int)4106, (float)gain);
        AL10.alSource((int)source.src.get(0), (int)4100, (FloatBuffer)sourcePos);
        AL10.alSource((int)source.src.get(0), (int)4102, (FloatBuffer)sourceVel);
        AL10.alSourcef((int)source.src.get(0), (int)4129, (float)0.0f);
        AL10.alSourceQueueBuffers((int)source.src.get(0), (IntBuffer)this.currentBuffer);
        int state = AL10.alGetSourcei((int)source.src.get(0), (int)4112);
        if (source.receivedPackets > this.BUFFER_PACKETS && state != 4114) {
            AL10.alSourcePlay((int)source.src.get(0));
        } else if (source.receivedPackets <= this.BUFFER_PACKETS) {
            AL10.alSourcePause((int)source.src.get(0));
        }
        ++source.receivedPackets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int sourceCount = this.sources.size();
        for (SourceEntry source : this.sources) {
            AL10.alSourceStop((int)source.src.get(0));
            AL10.alDeleteSources((int)source.src.get(0));
        }
        this.sources.clear();
        int bufferCount = 0;
        if (this.buffersPlayed != null) {
            ArrayList<IntBuffer> arrayList = this.buffersPlayed;
            synchronized (arrayList) {
                if (this.currentBuffer != null) {
                    this.buffersPlayed.add(this.currentBuffer);
                }
                for (IntBuffer b : this.buffersPlayed) {
                    b.rewind();
                    for (int i = 0; i < b.limit(); ++i) {
                        int buffer = b.get(i);
                        if (!AL10.alIsBuffer((int)buffer)) continue;
                        AL10.alDeleteBuffers((int)buffer);
                        ++bufferCount;
                    }
                }
                this.buffersPlayed.clear();
            }
        }
        AsieLibMod.log.debug("Cleaned " + bufferCount + " buffers and " + sourceCount + " sources.");
    }

    public class SourceEntry {
        public final int x;
        public final int y;
        public final int z;
        public final IntBuffer src;
        public int receivedPackets;

        public SourceEntry(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.src = BufferUtils.createIntBuffer((int)1);
            AL10.alGenSources((IntBuffer)this.src);
        }
    }
}

