/*
 * Decompiled with CFR 0.152.
 */
package portalgun.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import portalgun.client.core.IconList;
import portalgun.common.PortalGun;
import portalgun.common.core.Settings;
import portalgun.common.entity.EntityPedestal;
import portalgun.common.tileentity.TileEntityPortalMod;

public class BlockPortalMod
extends BlockContainer {
    public BlockPortalMod() {
        super(Material.field_151594_q);
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = IconList.portalSpawner;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return IconList.portalSpawner;
    }

    public void func_149719_a(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isSpawner && !tep.isPortal) {
                float f = 0.1f;
                if (tep.spSet == 0) {
                    this.func_149676_a(0.0f, 1.0f - f, 0.0f, 1.0f, 1.0f, 1.0f);
                } else if (tep.spSet == 1) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
                } else if (tep.spType == 1) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
                } else if (tep.spType == 2) {
                    this.func_149676_a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                } else if (tep.spType == 3) {
                    this.func_149676_a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
                } else if (tep.spType == 4) {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
                }
            } else {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int l, float f, float f1, float f2) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isSpawner && PortalGun.getSettings("canEditSpawners") == 1) {
                PortalGun.proxy.handleGUI(entityplayer, tep, 0);
                return true;
            }
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int i, int j, int k, EntityPlayer player) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isSpawner) {
                return new ItemStack(PortalGun.itemPortalSpawner, 1);
            }
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public TileEntity func_149915_a(World par1World, int i) {
        return new TileEntityPortalMod();
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
    }

    public boolean func_149707_d(World world, int i, int j, int k, int l) {
        if (world.func_147439_a(i, j, k).func_149688_o() == Material.field_151586_h || world.func_147439_a(i, j, k).func_149688_o() == Material.field_151587_i) {
            return false;
        }
        if (l == 0) {
            ++j;
        } else if (l == 1) {
            for (int ii = 0; ii < world.field_72996_f.size(); ++ii) {
                float f2;
                float f1;
                float f;
                float f3;
                Entity entity = (Entity)world.field_72996_f.get(ii);
                if (!(entity instanceof EntityPedestal) || !entity.func_70089_S() || !((f3 = MathHelper.func_76129_c((float)((f = (float)((double)i + 0.5 - entity.field_70165_t)) * f + (f1 = (float)((double)j - entity.field_70163_u)) * f1 + (f2 = (float)((double)k + 0.5 - entity.field_70161_v)) * f2))) < 0.4f)) continue;
                return false;
            }
            --j;
        } else if (l == 2) {
            ++k;
        } else if (l == 3) {
            --k;
        } else if (l == 4) {
            ++i;
        } else if (l == 5) {
            --i;
        }
        Block blockID = world.func_147439_a(i, j, k);
        int meta = world.func_72805_g(i, j, k);
        int[] metaArray = PortalGun.getBlockMetaInMap(Settings.portalBlockIds, blockID);
        if (metaArray != null) {
            if (PortalGun.getSettings("portalWhitelist") == 1) {
                boolean allowed = false;
                for (int metaList : metaArray) {
                    if (meta != metaList) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    return false;
                }
            } else {
                if (metaArray.length != 0 && metaArray[0] == -1) {
                    return false;
                }
                for (int metaList : metaArray) {
                    if (meta != metaList) continue;
                    return false;
                }
            }
        } else if (PortalGun.getSettings("portalWhitelist") == 1) {
            return false;
        }
        if (blockID == Blocks.field_150362_t) {
            return false;
        }
        return world.isSideSolid(i, j, k, ForgeDirection.getOrientation((int)l)) || blockID == Blocks.field_150426_aN;
    }

    public boolean isReplaceable(IBlockAccess world, int i, int j, int k) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isSpawner && !tep.isPortal) {
                return true;
            }
        }
        return false;
    }

    public int getLightValue(IBlockAccess iba, int i, int j, int k) {
        TileEntity te = iba.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isSpawner && !tep.isPortal) {
                return 0;
            }
        }
        return this.field_149784_t;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        if (!(world.func_147439_a(i, j + 1, k) != Blocks.field_150354_m && world.func_147439_a(i, j + 1, k) != Blocks.field_150351_n || world.field_72995_K)) {
            EntityFallingBlock entityfallingsand = new EntityFallingBlock(world, (double)((float)i + 0.5f), (double)((float)j + 1.0f + 0.5f), (double)((float)k + 0.5f), world.func_147439_a(i, j + 1, k));
            world.func_72838_d((Entity)entityfallingsand);
        }
    }

    public void func_149749_a(World world, int i, int j, int k, Block block, int meta) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.isPortal) {
                tep.removePortal();
            }
            if (tep.isSpawner) {
                tep.removeSpawner();
            }
        }
        super.func_149749_a(world, i, j, k, block, meta);
    }

    public void func_149695_a(World world, int i, int j, int k, Block l) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityPortalMod) {
            TileEntity te1;
            TileEntityPortalMod tep = (TileEntityPortalMod)te;
            if (tep.firstUpdate || world.func_147439_a(i, j, k) != this) {
                tep.queueUpdate = l;
                return;
            }
            if (!tep.isPortal && !tep.isSpawner) {
                world.func_147468_f(i, j, k);
                return;
            }
            if (tep.isPortal) {
                if (tep.tepPair != null && world.func_147439_a(tep.tepPair.field_145851_c, tep.tepPair.field_145848_d, tep.tepPair.field_145849_e) == PortalGun.blockPortal) {
                    te1 = world.func_147438_o(tep.tepPair.field_145851_c, tep.tepPair.field_145848_d, tep.tepPair.field_145849_e);
                    if (!te1.equals((Object)tep.tepPair)) {
                        tep.removePortal();
                    }
                } else {
                    tep.removePortal();
                }
                if (!this.func_149707_d(world, i, j, k, tep.sideOn)) {
                    tep.removePortal();
                }
            }
            if (tep.isSpawner) {
                if (tep.spPair != null && world.func_147439_a(tep.spPair.field_145851_c, tep.spPair.field_145848_d, tep.spPair.field_145849_e) == PortalGun.blockPortal) {
                    te1 = world.func_147438_o(tep.spPair.field_145851_c, tep.spPair.field_145848_d, tep.spPair.field_145849_e);
                    if (!te1.equals((Object)tep.spPair)) {
                        tep.removeSpawner();
                    }
                } else {
                    tep.removeSpawner();
                }
                if (!this.func_149707_d(world, i, j, k, tep.spSideOn)) {
                    tep.removeSpawner();
                }
                if (tep.isSpawner && !world.field_147482_g.contains((Object)tep)) {
                    if (tep.func_145831_w() == null) {
                        tep.func_145834_a(world);
                    }
                    tep.func_145845_h();
                }
            }
        }
        if (!(world.func_147439_a(i, j + 1, k) != Blocks.field_150354_m && world.func_147439_a(i, j + 1, k) != Blocks.field_150351_n || world.field_72995_K)) {
            EntityFallingBlock entityfallingsand = new EntityFallingBlock(world, (double)((float)i + 0.5f), (double)((float)j + 1.0f + 0.5f), (double)((float)k + 0.5f), world.func_147439_a(i, j + 1, k));
            world.func_72838_d((Entity)entityfallingsand);
        }
    }
}

