/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.idt;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.idt.config.BiomeConfigIDT;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.idt.RealisticBiomeIDTEbonyForest;
import rtg.world.biome.realistic.idt.RealisticBiomeIDTSilkwoodForest;
import rtg.world.biome.realistic.idt.RealisticBiomeIDTWillowForest;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeIDTBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase idtEbonyForest;
    public static RealisticBiomeBase idtSilkwoodForest;
    public static RealisticBiomeBase idtWillowForest;
    protected Block ebonyLogBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:EbonyLog");
    protected byte ebonyLogMeta = 0;
    protected Block ebonyLeavesBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:EbonyLeaves");
    protected byte ebonyLeavesMeta = 0;
    protected Block silkwoodLogBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:SilkwoodLog");
    protected byte silkwoodLogMeta = 0;
    protected Block silkwoodLeavesBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:SilkwoodLeaves");
    protected byte silkwoodLeavesMeta = 0;
    protected Block willowLogBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:WillowLog");
    protected byte willowLogMeta = 0;
    protected Block willowLeavesBlock = (Block)GameData.getBlockRegistry().func_82594_a("mod_IDT:WillowLeaves");
    protected byte willowLeavesMeta = 0;

    public RealisticBiomeIDTBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"mod_IDT")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase idtBiome = b[i];
                String biomeName = b[i].field_76791_y;
                String biomeClass = b[i].func_150562_l().getName();
                if (biomeName == "Ebony Forest" && biomeClass == "com.mce.gen.biome.EbonyForest") {
                    idtEbonyForest = new RealisticBiomeIDTEbonyForest(idtBiome, BiomeConfigIDT.biomeConfigIDTEbonyForest);
                    continue;
                }
                if (biomeName == "Silkwood Forest" && biomeClass == "com.mce.gen.biome.SilkwoodForest") {
                    idtSilkwoodForest = new RealisticBiomeIDTSilkwoodForest(idtBiome, BiomeConfigIDT.biomeConfigIDTSilkwoodForest);
                    continue;
                }
                if (biomeName != "Willow Forest" || biomeClass != "com.mce.gen.biome.WillowForest") continue;
                idtWillowForest = new RealisticBiomeIDTWillowForest(idtBiome, BiomeConfigIDT.biomeConfigIDTWillowForest);
            }
        }
    }
}

