/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenFlowersRTG;

public class DecoFlowersRTG
extends DecoBase {
    public int[] flowers = new int[]{0, 9};
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public HeightType heightType = HeightType.NEXT_INT;
    public int chance = 1;
    public int notEqualsZeroChance = 1;
    public int loops = 1;

    public DecoFlowersRTG() {
        this.addDecoTypes(DecoBase.DecoType.FLOWER);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            WorldGenFlowersRTG worldGenerator = new WorldGenFlowersRTG(this.flowers);
            this.loops = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : this.loops;
            for (int i = 0; i < this.loops * 16; ++i) {
                int intY;
                int intX = chunkX + rand.nextInt(16);
                int intZ = chunkY + rand.nextInt(16);
                switch (this.heightType) {
                    case NEXT_INT: {
                        intY = rand.nextInt(this.maxY);
                        break;
                    }
                    case GET_HEIGHT_VALUE: {
                        intY = world.func_72976_f(intX, intZ);
                        break;
                    }
                    default: {
                        intY = rand.nextInt(this.maxY);
                    }
                }
                if (this.notEqualsZeroChance > 1) {
                    if (rand.nextInt(this.notEqualsZeroChance) == 0) continue;
                    worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
                    continue;
                }
                if (rand.nextInt(this.chance) != 0) continue;
                worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }

    public static enum HeightType {
        NEXT_INT,
        GET_HEIGHT_VALUE;

    }
}

