/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.biome.deco.DecoBase;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.WorldGenCacti;

public class DecoCactus
extends DecoBase {
    public int loops = 1;
    public int chance = 1;
    public float strengthFactor = 0.0f;
    public int maxY = 255;
    public boolean sandOnly = false;
    public Block soilBlock = Blocks.field_150354_m;
    public byte soilMeta = 0;

    public DecoCactus() {
        this.addDecoTypes(DecoBase.DecoType.CACTUS);
    }

    @Override
    public void generate(RealisticBiomeBase biome, World world, Random rand, int chunkX, int chunkY, OpenSimplexNoise simplex, CellNoise cell, float strength, float river, boolean hasPlacedVillageBlocks) {
        if (this.allowed && TerrainGen.decorate((World)world, (Random)rand, (int)chunkX, (int)chunkY, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
            WorldGenCacti worldGenerator = new WorldGenCacti(this.sandOnly, 0, this.soilBlock, this.soilMeta);
            int loopCount = this.loops;
            loopCount = this.strengthFactor > 0.0f ? (int)(this.strengthFactor * strength) : loopCount;
            for (int i = 0; i < loopCount * 10; ++i) {
                int intX = chunkX + rand.nextInt(16);
                int intY = rand.nextInt(this.maxY);
                int intZ = chunkY + rand.nextInt(16);
                if (intY > this.maxY || rand.nextInt(this.chance) != 0) continue;
                worldGenerator.func_76484_a(world, rand, intX, intY, intZ);
            }
        }
    }
}

