/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome;

import net.minecraft.world.biome.BiomeGenBase;
import rtg.config.rtg.ConfigRTG;
import rtg.util.CircularSearchCreator;
import rtg.world.biome.realistic.RealisticBiomeBase;

public class BiomeAnalyzer {
    private boolean[] riverBiome;
    private boolean[] oceanBiome;
    private boolean[] swampBiome;
    private boolean[] beachBiome;
    private boolean[] landBiome;
    private int[] preferredBeach;
    private int[] searchPattern;
    private RealisticBiomeBase[] savedJittered = new RealisticBiomeBase[256];
    private int[] xyinverted = this.xyinverted();
    float beachTop = 64.5f;
    float beachBottom = 61.5f;
    float oceanTop = 61.5f;
    SearchStatus beach = new SearchStatus();
    SearchStatus land = new SearchStatus();
    SearchStatus ocean = new SearchStatus();
    private int sampleSize = 8;
    private RealisticBiomeBase scenicLakeBiome = RealisticBiomeBase.getBiome(ConfigRTG.scenicLakeBiome);
    private RealisticBiomeBase scenicFrozenLakeBiome = RealisticBiomeBase.getBiome(ConfigRTG.scenicFrozenLakeBiome);
    private SmoothingSearchStatus beachSearch;
    private SmoothingSearchStatus landSearch;
    private SmoothingSearchStatus oceanSearch;
    private static final int NO_BIOME = -1;

    public BiomeAnalyzer() {
        this.determineRiverBiomes();
        this.determineOceanBiomes();
        this.determineSwampBiomes();
        this.determineBeachBiomes();
        this.determineLandBiomes();
        this.determinePreferredBeaches();
        this.prepareSearchPattern();
        this.setSearches();
    }

    private void determineRiverBiomes() {
        this.riverBiome = new boolean[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            if (BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null || !BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("river")) continue;
            this.riverBiome[index] = true;
        }
    }

    private void determineOceanBiomes() {
        this.oceanBiome = new boolean[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            if (BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null) continue;
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("ocean")) {
                this.oceanBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("kelp")) {
                this.oceanBiome[index] = true;
            }
            if (!BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("coral")) continue;
            this.oceanBiome[index] = true;
        }
        this.oceanBiome[BiomeGenBase.field_150575_M.field_76756_M] = true;
    }

    private void determineSwampBiomes() {
        this.swampBiome = new boolean[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            if (BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null) continue;
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("swamp")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("bayou")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("bog")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("wetland")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("sludge")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("marsh")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("fen")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("moor")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("quagmire")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("ephemeral lake")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("rainforest valley")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("riparian zone")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("ice sheet")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("woodland lake")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("archipelago")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().equals("shield")) {
                this.swampBiome[index] = true;
            }
            if (BiomeGenBase.func_150568_d((int)index).field_76756_M != BiomeGenBase.field_76777_m.field_76756_M) continue;
            this.swampBiome[index] = true;
        }
    }

    private void determineLandBiomes() {
        this.landBiome = new boolean[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            if (this.oceanBiome[index] || this.riverBiome[index] || BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null || this.beachBiome[index] || BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().equals("lake")) continue;
            this.landBiome[index] = true;
        }
    }

    private void determineBeachBiomes() {
        this.beachBiome = new boolean[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            if (BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null) continue;
            if (BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("beach")) {
                this.beachBiome[index] = true;
            }
            if (!BiomeGenBase.func_150568_d((int)index).field_76791_y.toLowerCase().contains("mangrove")) continue;
            this.beachBiome[index] = true;
        }
    }

    private void determinePreferredBeaches() {
        this.preferredBeach = new int[BiomeGenBase.func_150565_n().length];
        for (int index = 0; index < BiomeGenBase.func_150565_n().length; ++index) {
            float height;
            if (BiomeGenBase.func_150568_d((int)index) == null || BiomeGenBase.func_150568_d((int)index).field_76791_y == null) continue;
            RealisticBiomeBase realisticVersion = RealisticBiomeBase.getBiome(index);
            if (realisticVersion != null && realisticVersion.disallowAllBeaches) {
                this.preferredBeach[index] = index;
            }
            this.preferredBeach[index] = BiomeGenBase.func_150568_d((int)index).field_76750_F <= 0.05f ? BiomeGenBase.field_150577_O.field_76756_M : (realisticVersion != null && realisticVersion.disallowStoneBeaches ? BiomeGenBase.field_76787_r.field_76756_M : ((double)(height = BiomeGenBase.func_150568_d((int)index).field_76748_D + BiomeGenBase.func_150568_d((int)index).field_76749_E * 2.0f) > 1.5 ? BiomeGenBase.field_150576_N.field_76756_M : BiomeGenBase.field_76787_r.field_76756_M));
        }
    }

    public void newRepair(int[] genLayerBiomes, RealisticBiomeBase[] jitteredBiomes, int[] biomeNeighborhood, int neighborhoodSize, float[] noise, float[] riverStrength) {
        int foundBiome;
        int i;
        if (neighborhoodSize != this.sampleSize) {
            throw new RuntimeException("mismatch between chunk and analyzer neighborhood sizes");
        }
        for (i = 0; i < 256; ++i) {
            boolean canBeRiver = (double)riverStrength[i] > 0.7;
            this.savedJittered[i] = jitteredBiomes[i];
            if ((double)noise[i] > 61.5) {
                jitteredBiomes[i] = RealisticBiomeBase.getBiome(genLayerBiomes[this.xyinverted[i]]);
                continue;
            }
            if (canBeRiver && !this.oceanBiome[genLayerBiomes[this.xyinverted[i]]] && !this.swampBiome[genLayerBiomes[this.xyinverted[i]]]) {
                int riverBiomeID = RealisticBiomeBase.getBiome((int)genLayerBiomes[this.xyinverted[i]]).riverBiome.field_76756_M;
                jitteredBiomes[i] = RealisticBiomeBase.getBiome(riverBiomeID);
                continue;
            }
            jitteredBiomes[i] = RealisticBiomeBase.getBiome(genLayerBiomes[this.xyinverted[i]]);
        }
        this.beachSearch.notHunted = true;
        this.beachSearch.absent = false;
        for (i = 0; i < 256 && !this.beachSearch.absent; ++i) {
            if (noise[i] < this.beachBottom || noise[i] > this.riverAdjusted(this.beachTop, riverStrength[i]) || this.swampBiome[jitteredBiomes[i].baseBiome.field_76756_M]) continue;
            if (this.beachSearch.notHunted) {
                this.beachSearch.hunt(biomeNeighborhood);
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.beachSearch.biomes[i]) == -1) continue;
            int nearestLandBiome = this.landSearch.biomes[i];
            if (nearestLandBiome > -1) {
                foundBiome = this.preferredBeach[nearestLandBiome];
            }
            jitteredBiomes[i] = RealisticBiomeBase.getBiome(foundBiome);
        }
        this.landSearch.absent = false;
        this.landSearch.notHunted = true;
        for (i = 0; i < 256 && !this.landSearch.absent; ++i) {
            int foundBiome2;
            int biomeID;
            if (noise[i] < this.riverAdjusted(this.beachTop, riverStrength[i]) || this.landBiome[biomeID = jitteredBiomes[i].baseBiome.field_76756_M] || this.swampBiome[jitteredBiomes[i].baseBiome.field_76756_M]) continue;
            if (this.landSearch.notHunted) {
                this.landSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome2 = this.landSearch.biomes[i]) == -1) continue;
            jitteredBiomes[i] = RealisticBiomeBase.getBiome(foundBiome2);
        }
        this.oceanSearch.absent = false;
        this.oceanSearch.notHunted = true;
        for (i = 0; i < 256 && !this.oceanSearch.absent; ++i) {
            if (noise[i] > this.oceanTop || this.oceanBiome[jitteredBiomes[i].baseBiome.field_76756_M] || this.swampBiome[jitteredBiomes[i].baseBiome.field_76756_M] || this.riverBiome[jitteredBiomes[i].baseBiome.field_76756_M]) continue;
            if (this.oceanSearch.notHunted) {
                this.oceanSearch.hunt(biomeNeighborhood);
            }
            if ((foundBiome = this.oceanSearch.biomes[i]) == -1) continue;
            jitteredBiomes[i] = RealisticBiomeBase.getBiome(foundBiome);
        }
        for (i = 0; i < 256; ++i) {
            if (!((double)noise[i] <= 61.5) || this.riverBiome[jitteredBiomes[i].baseBiome.field_76756_M] || this.oceanBiome[jitteredBiomes[i].baseBiome.field_76756_M] || this.swampBiome[jitteredBiomes[i].baseBiome.field_76756_M] || this.beachBiome[jitteredBiomes[i].baseBiome.field_76756_M]) continue;
            int riverReplacement = jitteredBiomes[i].riverBiome.field_76756_M;
            jitteredBiomes[i] = riverReplacement == BiomeGenBase.field_76777_m.field_76756_M ? this.scenicFrozenLakeBiome : this.scenicLakeBiome;
        }
    }

    private void prepareSearchPattern() {
        this.searchPattern = new CircularSearchCreator().pattern();
    }

    public int[] xyinverted() {
        int i;
        int[] result = new int[256];
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                result[i * 16 + j] = j * 16 + i;
            }
        }
        for (i = 0; i < 256; ++i) {
            if (result[result[i]] == i) continue;
            throw new RuntimeException("" + i + "" + result[i] + " " + result[result[i]]);
        }
        return result;
    }

    private void setSearches() {
        this.beachSearch = new SmoothingSearchStatus(this.beachBiome);
        this.landSearch = new SmoothingSearchStatus(this.landBiome);
        this.oceanSearch = new SmoothingSearchStatus(this.oceanBiome);
    }

    private float deriverized(float height, float river) {
        if (river >= 1.0f) {
            return height;
        }
        float erodedRiver = river / 0.1875f;
        if (erodedRiver <= 1.0f) {
            height = (height - 58.0f * erodedRiver) / (1.0f - erodedRiver);
        }
        height = (height - 62.0f * river) / (1.0f - river);
        return height;
    }

    private float riverAdjusted(float top, float river) {
        if (river >= 1.0f) {
            return top;
        }
        float erodedRiver = river / 0.1875f;
        if (erodedRiver <= 1.0f) {
            top = top * (1.0f - erodedRiver) + 62.0f * erodedRiver;
        }
        top = top * (1.0f - river) + 62.0f * river;
        return top;
    }

    private class SmoothingSearchStatus {
        boolean absent = false;
        boolean notHunted;
        private int[] findings = new int[9];
        private float[] weightings = new float[9];
        public int[] biomes = new int[256];
        private boolean[] desired;
        private int arraySize;
        private int[] pattern;
        private final int upperLeftFinding = 0;
        private final int upperRightFinding = 3;
        private final int lowerLeftFinding = 1;
        private final int lowerRightFinding = 4;
        private final int[] quadrantBiome = new int[4];
        private final float[] quadrantBiomeWeighting = new float[4];
        private int biomeCount;

        SmoothingSearchStatus(boolean[] desired) {
            this.desired = desired;
        }

        private final int size() {
            return 3;
        }

        private void clear() {
            for (int i = 0; i < this.findings.length; ++i) {
                this.findings[i] = -1;
            }
        }

        public void hunt(int[] biomeNeighborhood) {
            this.clear();
            int oldArraySize = this.arraySize;
            this.arraySize = (int)Math.sqrt(biomeNeighborhood.length);
            if (this.arraySize * this.arraySize != biomeNeighborhood.length) {
                throw new RuntimeException("non-square array");
            }
            if (this.arraySize != oldArraySize) {
                this.pattern = new CircularSearchCreator().pattern(this.arraySize / 2 - 1, this.arraySize);
            }
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                    this.search(xOffset, yOffset, biomeNeighborhood);
                }
            }
            this.smoothBiomes();
        }

        private final void search(int xOffset, int yOffset, int[] biomeNeighborhood) {
            int offset = xOffset * this.arraySize + yOffset;
            int location = (xOffset + 1) * this.size() + yOffset + 1;
            this.findings[location] = -1;
            this.weightings[location] = 2.0f;
            for (int i = 0; i < this.pattern.length; ++i) {
                int biome = biomeNeighborhood[this.pattern[i] + offset];
                if (!this.desired[biome]) continue;
                this.findings[location] = biome;
                this.weightings[location] = (float)Math.sqrt(this.pattern.length) - (float)Math.sqrt(i) + 2.0f;
                break;
            }
        }

        private void setBiomes() {
            for (int i = 0; i < 256; ++i) {
                this.biomes[i] = this.findings[4];
            }
            if (this.findings[4] == -1) {
                this.absent = true;
            }
        }

        private void smoothBiomes() {
            this.smoothQuadrant(this.biomeIndex(0, 0), 0);
            this.smoothQuadrant(this.biomeIndex(8, 0), 3);
            this.smoothQuadrant(this.biomeIndex(0, 8), 1);
            this.smoothQuadrant(this.biomeIndex(8, 8), 4);
        }

        private final int biomeIndex(int x, int y) {
            return x * 16 + y;
        }

        private void addBiome(int biome) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                return;
            }
            this.quadrantBiome[this.biomeCount++] = biome;
        }

        private void addWeight(int biome, float weight) {
            for (int i = 0; i < this.biomeCount; ++i) {
                if (biome != this.quadrantBiome[i]) continue;
                int n = i;
                this.quadrantBiomeWeighting[n] = this.quadrantBiomeWeighting[n] + weight;
                return;
            }
        }

        private int preferredBiome() {
            float bestWeight = 0.0f;
            int result = -2;
            for (int i = 0; i < this.biomeCount; ++i) {
                if (!(this.quadrantBiomeWeighting[i] > bestWeight)) continue;
                bestWeight = this.quadrantBiomeWeighting[i];
                result = this.quadrantBiome[i];
            }
            return result;
        }

        private void smoothQuadrant(int biomesOffset, int findingsOffset) {
            int upperLeft = this.findings[0 + findingsOffset];
            int upperRight = this.findings[3 + findingsOffset];
            int lowerLeft = this.findings[1 + findingsOffset];
            int lowerRight = this.findings[4 + findingsOffset];
            if (upperLeft == upperRight && upperLeft == lowerLeft && upperLeft == lowerRight) {
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        this.biomes[this.biomeIndex((int)x, (int)y) + biomesOffset] = upperLeft;
                    }
                }
                return;
            }
            this.biomeCount = 0;
            this.addBiome(upperLeft);
            this.addBiome(upperRight);
            this.addBiome(lowerLeft);
            this.addBiome(lowerRight);
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    this.addBiome(lowerRight);
                    for (int i = 0; i < 4; ++i) {
                        this.quadrantBiomeWeighting[i] = 0.0f;
                    }
                    this.addWeight(upperLeft, this.weightings[0 + findingsOffset] * (float)(7 - x) * (float)(7 - y));
                    this.addWeight(upperRight, this.weightings[3 + findingsOffset] * (float)x * (float)(7 - y));
                    this.addWeight(lowerLeft, this.weightings[1 + findingsOffset] * (float)(7 - x) * (float)y);
                    this.addWeight(lowerRight, this.weightings[4 + findingsOffset] * (float)x * (float)y);
                    this.biomes[this.biomeIndex((int)x, (int)y) + biomesOffset] = this.preferredBiome();
                }
            }
        }

        private void adjust(int[] chunkBiomeArray) {
            if (chunkBiomeArray.length != 256) {
                throw new RuntimeException();
            }
        }
    }

    private class SearchStatus {
        boolean absent = false;
        boolean notHunted = true;
        RealisticBiomeBase biome;

        private SearchStatus() {
        }
    }
}

