/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.HashMap;
import rtg.RTG;
import rtg.util.StringWriter;

public class TimeTracker {
    private boolean stopped;
    private int depth;
    private int maxDepth;
    private long startTime;
    private long stopTime;
    private long totalOn = 0L;
    private long totalOff = 0L;
    public static final Manager manager = new Manager();

    public String report() {
        return new String(" on proportion " + (float)this.totalOn / (float)(this.totalOn + this.totalOff + 1L) + " max depth " + this.maxDepth);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        ++this.depth;
        if (this.depth > this.maxDepth) {
            ++this.maxDepth;
        }
        if (this.stopped) {
            this.totalOff += this.startTime - this.stopTime;
            this.stopped = false;
        }
    }

    public void stop() {
        --this.depth;
        if (this.depth == 0) {
            this.stopTime = System.currentTimeMillis();
            this.stopped = true;
            this.totalOn += this.stopTime - this.startTime;
        }
    }

    public static class Manager {
        private HashMap<String, TimeTracker> trackers = new HashMap();

        private Manager() {
            RTG.instance.runOnServerClose(this.runReport());
        }

        private Runnable runReport() {
            return new Runnable(){

                @Override
                public void run() {
                    Manager.this.report();
                }
            };
        }

        private TimeTracker tracker(String name) {
            TimeTracker result = this.trackers.get(name);
            if (result == null) {
                result = new TimeTracker();
                this.trackers.put(name, result);
            }
            return result;
        }

        public void start(String name) {
            this.tracker(name).start();
        }

        public void stop(String name) {
            this.tracker(name).stop();
        }

        public void report() {
            if (this.trackers.size() < 1) {
                return;
            }
            StringWriter output = StringWriter.from("TimeUsage.txt");
            for (String name : this.trackers.keySet()) {
                output.accept(name + " " + this.trackers.get(name).report());
            }
            output.done();
        }
    }
}

