/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import rtg.util.Streamer;

public class Named<Type> {
    public String name;
    public Type object;

    public Named(String theName, Type theObject) {
        this.name = theName;
        this.object = theObject;
    }

    public static <T> Named<T> from(String name, T object) {
        return new Named<T>(name, object);
    }

    public static <StreamerType> NamedStreamer<StreamerType> streamer(Streamer<StreamerType> streamer) {
        return new NamedStreamer<StreamerType>(streamer);
    }

    public static class NamedStreamer<Type>
    extends Streamer<Named<Type>> {
        private final Streamer<Type> streamer;

        public NamedStreamer(Streamer<Type> streamer) {
            this.streamer = streamer;
        }

        @Override
        public Named<Type> readFrom(DataInput input) throws IOException {
            String name = input.readUTF();
            return new Named<Type>(name, this.streamer.readFrom(input));
        }

        @Override
        public void writeTo(Named<Type> written, DataOutput output) throws IOException {
            output.writeUTF(written.name);
            this.streamer.writeTo(written.object, output);
        }
    }
}

