/*
 * Decompiled with CFR 0.152.
 */
package rtg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LimitedMap<Key, Value>
implements Map<Key, Value> {
    private int limit;
    private int nextIndex = 0;
    private boolean reachedLimit = false;
    private final ArrayList<Key> keyList;
    private final HashMap<Key, Value> map;

    public LimitedMap(int maximumSize) {
        this.limit = maximumSize;
        this.keyList = new ArrayList(this.limit);
        this.map = new HashMap(this.limit);
    }

    @Override
    public int size() {
        if (this.reachedLimit) {
            return this.limit;
        }
        return this.nextIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.keyList.contains(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        for (Value value : this.map.values()) {
            if (!value.equals(arg0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value get(Object arg0) {
        return this.map.get(arg0);
    }

    @Override
    public synchronized Value put(Key arg0, Value arg1) {
        if (this.reachedLimit) {
            this.map.remove(this.keyList.get(this.nextIndex));
            this.keyList.set(this.nextIndex++, arg0);
            if (this.nextIndex >= this.limit) {
                this.nextIndex = 0;
            }
        } else {
            this.keyList.add(arg0);
            ++this.nextIndex;
            if (this.nextIndex >= this.limit) {
                this.reachedLimit = true;
                this.nextIndex = 0;
            }
        }
        return this.map.put(arg0, arg1);
    }

    @Override
    public Value remove(Object arg0) {
        return null;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> arg0) {
        for (Key key : arg0.keySet()) {
            this.put(key, arg0.get(key));
        }
    }

    @Override
    public void clear() {
        this.nextIndex = 0;
        this.reachedLimit = false;
        this.keyList.clear();
        this.map.clear();
    }

    @Override
    public Set<Key> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Value> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return this.map.entrySet();
    }
}

