/*
 * Decompiled with CFR 0.152.
 */
package rtg.event;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import rtg.config.rtg.ConfigRTG;
import rtg.util.Acceptor;
import rtg.util.Logger;
import rtg.util.RandomUtil;
import rtg.world.WorldTypeRTG;
import rtg.world.biome.WorldChunkManagerRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.MapGenCavesRTG;
import rtg.world.gen.MapGenRavineRTG;
import rtg.world.gen.feature.tree.rtg.TreeRTG;
import rtg.world.gen.genlayer.RiverRemover;
import rtg.world.gen.structure.MapGenScatteredFeatureRTG;
import rtg.world.gen.structure.MapGenVillageRTG;

public class EventManagerRTG {
    private final WorldEventRTG WORLD_EVENT_HANDLER = new WorldEventRTG();
    private final LoadChunkRTG LOAD_CHUNK_EVENT_HANDLER = new LoadChunkRTG();
    private final GenerateMinableRTG GENERATE_MINABLE_EVENT_HANDLER = new GenerateMinableRTG();
    private final InitBiomeGensRTG INIT_BIOME_GENS_EVENT_HANDLER = new InitBiomeGensRTG();
    private final InitMapGenRTG INIT_MAP_GEN_EVENT_HANDLER = new InitMapGenRTG();
    private final SaplingGrowTreeRTG SAPLING_GROW_TREE_EVENT_HANDLER = new SaplingGrowTreeRTG();
    private final DecorateBiomeEventRTG DECORATE_BIOME_EVENT_HANDLER = new DecorateBiomeEventRTG();
    private WeakHashMap<Integer, Acceptor<ChunkEvent.Load>> chunkLoadEvents = new WeakHashMap();
    private long worldSeed;
    private boolean isWorldTypeRTG = true;

    public void registerEventHandlers() {
        EventManagerRTG.logEventMessage("Registering RTG's event handlers...");
        MinecraftForge.EVENT_BUS.register((Object)this.WORLD_EVENT_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)this.LOAD_CHUNK_EVENT_HANDLER);
        MinecraftForge.ORE_GEN_BUS.register((Object)this.GENERATE_MINABLE_EVENT_HANDLER);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.INIT_BIOME_GENS_EVENT_HANDLER);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.INIT_MAP_GEN_EVENT_HANDLER);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.SAPLING_GROW_TREE_EVENT_HANDLER);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.DECORATE_BIOME_EVENT_HANDLER);
        EventManagerRTG.logEventMessage("RTG's event handlers have been registered successfully.");
    }

    public void setDimensionChunkLoadEvent(int dimension, Acceptor<ChunkEvent.Load> action) {
        this.chunkLoadEvents.put(dimension, action);
    }

    private static void logEventMessage(String message) {
        Logger.debug("RTG Event System: " + message, new Object[0]);
    }

    public class DecorateBiomeEventRTG {
        DecorateBiomeEventRTG() {
            EventManagerRTG.logEventMessage("Initialising DecorateBiomeEventRTG...");
        }

        @SubscribeEvent
        public void preBiomeDecorate(DecorateBiomeEvent.Pre event) {
            EventManagerRTG.this.isWorldTypeRTG = event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG;
        }
    }

    public class WorldEventRTG {
        WorldEventRTG() {
            EventManagerRTG.logEventMessage("Initialising WorldEventRTG...");
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (EventManagerRTG.this.worldSeed != event.world.func_72905_C() && event.world.func_72905_C() != 0L) {
                EventManagerRTG.this.worldSeed = event.world.func_72905_C();
                Logger.info("World Seed: " + EventManagerRTG.this.worldSeed, new Object[0]);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload event) {
            EventManagerRTG.this.worldSeed = 0L;
        }
    }

    public class SaplingGrowTreeRTG {
        SaplingGrowTreeRTG() {
            EventManagerRTG.logEventMessage("Initialising SaplingGrowTreeRTG...");
        }

        @SubscribeEvent
        public void saplingGrowTreeRTG(SaplingGrowTreeEvent event) {
            if (!ConfigRTG.enableRTGSaplings) {
                return;
            }
            if (!(event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG) || !(event.world.func_72959_q() instanceof WorldChunkManagerRTG)) {
                return;
            }
            Random rand = event.rand;
            if (rand.nextInt(ConfigRTG.rtgTreeChance) != 0) {
                Logger.debug("Skipping RTG tree generation.", new Object[0]);
                return;
            }
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            Block saplingBlock = world.func_147439_a(x, y, z);
            byte saplingMeta = (byte)saplingBlock.func_149643_k(world, x, y, z);
            WorldChunkManagerRTG cmr = (WorldChunkManagerRTG)world.func_72959_q();
            BiomeGenBase bgg = world.func_72807_a(x, z);
            RealisticBiomeBase rb = RealisticBiomeBase.getBiome(bgg.field_76756_M);
            ArrayList<TreeRTG> biomeTrees = rb.rtgTrees;
            Logger.debug("Biome = %s", rb.baseBiome.field_76791_y);
            Logger.debug("Ground Sapling Block = %s", saplingBlock.func_149732_F());
            Logger.debug("Ground Sapling Meta = %d", saplingMeta);
            if (biomeTrees.size() > 0) {
                ArrayList<TreeRTG> validTrees = new ArrayList<TreeRTG>();
                for (int i = 0; i < biomeTrees.size(); ++i) {
                    Logger.debug("Biome Tree #%d = %s", i, ((Object)((Object)biomeTrees.get(i))).getClass().getName());
                    Logger.debug("Biome Tree #%d Sapling Block = %s", i, biomeTrees.get((int)i).saplingBlock.getClass().getName());
                    Logger.debug("Biome Tree #%d Sapling Meta = %d", i, biomeTrees.get((int)i).saplingMeta);
                    if (saplingBlock != biomeTrees.get((int)i).saplingBlock || saplingMeta != biomeTrees.get((int)i).saplingMeta) continue;
                    validTrees.add(biomeTrees.get(i));
                    Logger.debug("Valid tree found!", new Object[0]);
                }
                if (validTrees.size() > 0) {
                    TreeRTG tree = (TreeRTG)((Object)validTrees.get(rand.nextInt(validTrees.size())));
                    Logger.debug("Tree = %s", ((Object)((Object)tree)).getClass().getName());
                    if (tree.minTrunkSize > 0 && tree.maxTrunkSize > tree.minTrunkSize) {
                        tree.trunkSize = RandomUtil.getRandomInt(rand, tree.minTrunkSize, tree.maxTrunkSize);
                    }
                    if (tree.minCrownSize > 0 && tree.maxCrownSize > tree.minCrownSize) {
                        tree.crownSize = RandomUtil.getRandomInt(rand, tree.minCrownSize, tree.maxCrownSize);
                    }
                    int oldFlag = tree.generateFlag;
                    tree.generateFlag = 3;
                    boolean generated = tree.func_76484_a(world, rand, x, y, z);
                    tree.generateFlag = oldFlag;
                    if (generated) {
                        event.setResult(Event.Result.DENY);
                        if (world.func_147439_a(x, y, z) == saplingBlock) {
                            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                        }
                    }
                } else {
                    Logger.debug("There are no RTG trees associated with the sapling on the ground. Generating a vanilla tree instead.", new Object[0]);
                }
            }
        }
    }

    public class InitMapGenRTG {
        InitMapGenRTG() {
            EventManagerRTG.logEventMessage("Initialising InitMapGenRTG...");
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public void initMapGenRTG(InitMapGenEvent event) {
            block9: {
                try {
                    if (!(MinecraftServer.func_71276_C().func_71218_a(0).func_72912_H().func_76067_t() instanceof WorldTypeRTG)) {
                        return;
                    }
                }
                catch (Exception e) {
                    Logger.debug("Overworld not loaded... checking global variable.", new Object[0]);
                    if (EventManagerRTG.this.isWorldTypeRTG) break block9;
                    return;
                }
            }
            Logger.debug("event type = %s", event.type.toString());
            Logger.debug("event originalGen = %s", event.originalGen.toString());
            switch (event.type) {
                case SCATTERED_FEATURE: {
                    if (!ConfigRTG.enableScatteredFeatureModifications) break;
                    event.newGen = new MapGenScatteredFeatureRTG();
                    break;
                }
                case VILLAGE: {
                    if (!ConfigRTG.enableVillageModifications) break;
                    event.newGen = new MapGenVillageRTG();
                    break;
                }
                case CAVE: {
                    if (!ConfigRTG.enableCaveModifications) break;
                    event.newGen = new MapGenCavesRTG();
                    break;
                }
                case RAVINE: {
                    if (!ConfigRTG.enableRavineModifications) break;
                    event.newGen = new MapGenRavineRTG();
                    break;
                }
            }
            Logger.debug("event newGen = %s", event.newGen.toString());
        }
    }

    public class InitBiomeGensRTG {
        InitBiomeGensRTG() {
            EventManagerRTG.logEventMessage("Initialising InitBiomeGensRTG...");
        }

        @SubscribeEvent
        public void initBiomeGensRTG(WorldTypeEvent.InitBiomeGens event) {
            if (!(event.worldType instanceof WorldTypeRTG)) {
                return;
            }
            if (event.newBiomeGens[0].getClass().getName().contains("GenLayerEB")) {
                return;
            }
            try {
                event.newBiomeGens = new RiverRemover().riverLess(event.originalBiomeGens);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public class GenerateMinableRTG {
        GenerateMinableRTG() {
            EventManagerRTG.logEventMessage("Initialising GenerateMinableRTG...");
        }

        @SubscribeEvent
        public void generateMinableRTG(OreGenEvent.GenerateMinable event) {
            if (!(event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG)) {
                return;
            }
            switch (event.type) {
                case COAL: {
                    if (!ConfigRTG.generateOreCoal) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
                case IRON: {
                    if (!ConfigRTG.generateOreIron) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
                case REDSTONE: {
                    if (!ConfigRTG.generateOreRedstone) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
                case GOLD: {
                    if (!ConfigRTG.generateOreGold) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
                case LAPIS: {
                    if (!ConfigRTG.generateOreLapis) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
                case DIAMOND: {
                    if (!ConfigRTG.generateOreDiamond) {
                        event.setResult(Event.Result.DENY);
                    }
                    return;
                }
            }
        }
    }

    public class LoadChunkRTG {
        LoadChunkRTG() {
            EventManagerRTG.logEventMessage("Initialising LoadChunkRTG...");
        }

        @SubscribeEvent
        public void loadChunkRTG(ChunkEvent.Load event) {
            if (!(event.world.func_72912_H().func_76067_t() instanceof WorldTypeRTG)) {
                return;
            }
            Acceptor acceptor = (Acceptor)EventManagerRTG.this.chunkLoadEvents.get(event.world.field_73011_w.field_76574_g);
            if (acceptor != null) {
                acceptor.accept(event);
            }
        }
    }
}

