/*
 * Decompiled with CFR 0.152.
 */
package rtg.config.rtg;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import rtg.util.Logger;
import rtg.util.ModPresenceTester;

public class ConfigRTG {
    public static Configuration config;
    public static int flatBedrockLayers;
    public static String bedrockBlockId;
    public static int bedrockBlockByte;
    public static boolean enableRTGBiomeDecorations;
    public static boolean enableRTGBiomeSurfaces;
    public static int patchBiomeId;
    public static boolean enableCobblestoneBoulders;
    public static int cobblestoneBoulderChance;
    public static boolean enableUBCBoulders;
    public static boolean enableCaveModifications;
    public static boolean enableCaves;
    public static int caveDensity;
    public static int caveFrequency;
    public static int duneHeight;
    public static boolean enableDebugging;
    public static boolean generateDungeons;
    public static int dungeonFrequency;
    public static int flowingWaterChance;
    public static int flowingLavaChance;
    public static boolean enableWaterSurfaceLakes;
    public static int waterSurfaceLakeChance;
    public static boolean enableLavaSurfaceLakes;
    public static int lavaSurfaceLakeChance;
    public static boolean enableWaterUndergroundLakes;
    public static int waterUndergroundLakeChance;
    public static boolean enableLavaUndergroundLakes;
    public static int lavaUndergroundLakeChance;
    public static boolean generateMineshafts;
    public static boolean generateOreCoal;
    public static boolean generateOreIron;
    public static boolean generateOreGold;
    public static boolean generateOreRedstone;
    public static boolean generateOreLapis;
    public static boolean generateOreDiamond;
    public static boolean generateOreEmerald;
    public static String mesaClayColourString;
    public static String mesaBryceClayColourString;
    public static String savannaClayColourString;
    public static byte[] mesaClayColours;
    public static byte[] mesaBryceClayColours;
    public static byte[] savannaClayColours;
    public static boolean stoneSavannas;
    public static boolean enableRavineModifications;
    public static boolean enableRavines;
    public static int ravineFrequency;
    public static boolean enableRTGSaplings;
    public static int rtgTreeChance;
    public static boolean enableScatteredFeatureModifications;
    public static boolean generateScatteredFeatures;
    public static int minDistanceScatteredFeatures;
    public static int maxDistanceScatteredFeatures;
    public static boolean enableSnowLayers;
    public static boolean generateStrongholds;
    public static String shadowStoneBlockId;
    public static int shadowStoneBlockByte;
    public static String shadowDesertBlockId;
    public static int shadowDesertBlockByte;
    public static boolean enableUBCStoneShadowing;
    public static boolean enableUBCDesertShadowing;
    public static boolean allowTreesToGenerateOnSand;
    public static boolean allowShrubsToGenerateBelowSurface;
    public static boolean generateVillages;
    public static boolean enableVillageModifications;
    public static int villageSize;
    public static int minDistanceVillages;
    public static int maxDistanceVillages;
    public static boolean villageCrashFix;
    public static String volcanoBlockId;
    public static int volcanoBlockMeta;
    public static String volcanoMix1BlockId;
    public static int volcanoMix1BlockMeta;
    public static String volcanoMix2BlockId;
    public static int volcanoMix2BlockMeta;
    public static String volcanoMix3BlockId;
    public static int volcanoMix3BlockMeta;
    public static boolean enableVolcanoes;
    public static boolean enableVolcanoEruptions;
    public static int volcanoChance;
    private static float riverSizeMultiplier;
    public static float riverFrequencyMultiplier;
    public static float riverBendinessMultiplier;
    public static float riverCutOffScale;
    public static float riverCutOffAmplitude;
    private static float lakeSizeMultiplier;
    public static float lakeFrequencyMultiplier;
    public static float lakeShoreBendinessMultiplier;
    public static int scenicLakeBiome;
    public static int scenicFrozenLakeBiome;
    private static String riversAndLakes;

    public static float riverSizeMultiplier() {
        return riverSizeMultiplier * riverFrequencyMultiplier;
    }

    public static float lakeSizeMultiplier() {
        return lakeSizeMultiplier * lakeFrequencyMultiplier;
    }

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            flatBedrockLayers = config.getInt("Number of flat bedrock layers", "Bedrock", flatBedrockLayers, 0, 5, "0 = Normal bedrock (rough pattern); 1-5 = Number of flat bedrock layers to generate" + Configuration.NEW_LINE);
            bedrockBlockId = config.getString("Bedrock block ID", "Bedrock", bedrockBlockId, "The block to use for the bottom of the Overworld." + Configuration.NEW_LINE);
            bedrockBlockByte = config.getInt("Bedrock block meta value", "Bedrock", bedrockBlockByte, 0, 15, "The meta value of the bedrock block." + Configuration.NEW_LINE);
            enableRTGBiomeDecorations = config.getBoolean("Enable RTG Biome Decorations", "Biomes", enableRTGBiomeDecorations, "If TRUE, uses the individual biome settings in the biome config files. If FALSE, disables all RTG decorations and uses vanilla decorations instead." + Configuration.NEW_LINE);
            enableRTGBiomeSurfaces = config.getBoolean("Enable RTG Biome Surfaces", "Biomes", enableRTGBiomeSurfaces, "If TRUE, uses the individual biome settings in the biome config files. If FALSE, disables all RTG surfaces and uses vanilla surfaces instead." + Configuration.NEW_LINE);
            patchBiomeId = config.getInt("Patch Biome ID", "Biomes", patchBiomeId, -1, 255, "If RTG tries to generate an unsupported biome or a biome that has an ID conflict, it will generate this biome instead." + Configuration.NEW_LINE + "If set to -1, RTG will crash instead of generating the patch biome. You might want to do this if you're making a mod pack" + Configuration.NEW_LINE + "and want to make sure all biomes are generating correctly." + Configuration.NEW_LINE + "Default = Vanilla Plains" + Configuration.NEW_LINE);
            enableCobblestoneBoulders = config.getBoolean("Enable Cobblestone Boulders", "Boulders", enableCobblestoneBoulders, "");
            cobblestoneBoulderChance = config.getInt("1/x chance that Cobblestone Boulders will generate if given the opportunity to do so during world gen", "Boulders", cobblestoneBoulderChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableUBCBoulders = config.getBoolean("UBC Boulders", "Boulders", enableUBCStoneShadowing, "Set this to TRUE to allow UBC to override cobblestone boulders." + Configuration.NEW_LINE + "This setting doesn't have any effect if UBC is not installed." + Configuration.NEW_LINE);
            enableCaveModifications = config.getBoolean("Enable Cave Modifications", "Caves", enableCaveModifications, "Must be set to TRUE for the other cave settings to have any effect." + Configuration.NEW_LINE + "If FALSE, RTG won't interfere with cave generation at all." + Configuration.NEW_LINE);
            enableCaves = config.getBoolean("Enable Caves", "Caves", enableCaves, "");
            caveDensity = config.getInt("Cave Density", "Caves", caveDensity, 1, 40, "This setting controls the size of caves." + Configuration.NEW_LINE + "HIGHER values = BIGGER caves & MORE lag. (14 = vanilla cave density)" + Configuration.NEW_LINE);
            caveFrequency = config.getInt("Cave Frequency", "Caves", caveFrequency, 1, 40, "This setting controls the number of caves that generate." + Configuration.NEW_LINE + "LOWER values = MORE caves & MORE lag. (6 = vanilla cave frequency)" + Configuration.NEW_LINE);
            duneHeight = config.getInt("Height of Dunes", "Dunes", duneHeight, 1, 12, "This setting controls the height of both sand dunes and snow dunes." + Configuration.NEW_LINE + "Higher values = taller dunes." + Configuration.NEW_LINE);
            enableDebugging = config.getBoolean("Enable Debugging", "Debugging", enableDebugging, "WARNING: This should only be enabled if you know what you're doing." + Configuration.NEW_LINE);
            generateDungeons = config.getBoolean("Generate Dungeons", "Dungeons", generateDungeons, "");
            dungeonFrequency = config.getInt("Dungeon Frequency", "Dungeons", dungeonFrequency, 1, 200, "This setting controls the number of dungeons that generate." + Configuration.NEW_LINE + "HIGHER values = MORE dungeons & MORE lag. (8 = vanilla dungeon frequency)" + Configuration.NEW_LINE);
            flowingLavaChance = config.getInt("Flowing Lava Chance", "Flowing Liquids", flowingLavaChance, 0, Integer.MAX_VALUE, "1/x chance that a lava stream will generate on the side of a hill or mountain." + Configuration.NEW_LINE + "0 = Never generate; 1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            flowingWaterChance = config.getInt("Flowing Water Chance", "Flowing Liquids", flowingWaterChance, 0, Integer.MAX_VALUE, "1/x chance that a water stream will generate on the side of a hill or mountain." + Configuration.NEW_LINE + "0 = Never generate; 1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableWaterSurfaceLakes = config.getBoolean("Enable Water Surface Lakes", "Lakes (Surface)", enableWaterSurfaceLakes, "");
            waterSurfaceLakeChance = config.getInt("1/x chance that Water Surface Lakes will generate if given the opportunity to do so during world gen", "Lakes (Surface)", waterSurfaceLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableLavaSurfaceLakes = config.getBoolean("Enable Lava Surface Lakes", "Lakes (Surface)", enableLavaSurfaceLakes, "");
            lavaSurfaceLakeChance = config.getInt("1/x chance that Lava Surface Lakes will generate if given the opportunity to do so during world gen", "Lakes (Surface)", lavaSurfaceLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableWaterUndergroundLakes = config.getBoolean("Enable Water Underground Lakes", "Lakes (Underground)", enableWaterUndergroundLakes, "");
            waterUndergroundLakeChance = config.getInt("1/x chance that Water Underground Lakes will generate if given the opportunity to do so during world gen", "Lakes (Underground)", waterUndergroundLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableLavaUndergroundLakes = config.getBoolean("Enable Lava Underground Lakes", "Lakes (Underground)", enableLavaUndergroundLakes, "");
            lavaUndergroundLakeChance = config.getInt("1/x chance that Lava Underground Lakes will generate if given the opportunity to do so during world gen", "Lakes (Underground)", lavaUndergroundLakeChance, 1, 100, "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            generateMineshafts = config.getBoolean("Generate Mineshafts", "Mineshafts", generateMineshafts, "");
            generateOreCoal = config.getBoolean("Generate Coal Ore", "Ore Gen", generateOreCoal, "");
            generateOreIron = config.getBoolean("Generate Iron Ore", "Ore Gen", generateOreIron, "");
            generateOreGold = config.getBoolean("Generate Gold Ore", "Ore Gen", generateOreGold, "");
            generateOreRedstone = config.getBoolean("Generate Redstone Ore", "Ore Gen", generateOreRedstone, "");
            generateOreLapis = config.getBoolean("Generate Lapis Lazuli Ore", "Ore Gen", generateOreLapis, "");
            generateOreDiamond = config.getBoolean("Generate Diamond Ore", "Ore Gen", generateOreDiamond, "");
            generateOreEmerald = config.getBoolean("Generate Emerald Ore", "Ore Gen", generateOreEmerald, "");
            mesaClayColours = ConfigRTG.getClayColourMetasFromConfigString(config.getString("Mesa Clay Colours", "Plateaus", mesaClayColourString, ConfigRTG.getPlateauClayColourComment("Mesa biome variants (doesn't include Mesa Bryce)")));
            mesaBryceClayColours = ConfigRTG.getClayColourMetasFromConfigString(config.getString("Mesa Bryce Clay Colours", "Plateaus", mesaBryceClayColourString, ConfigRTG.getPlateauClayColourComment("Mesa Bryce biome")));
            savannaClayColours = ConfigRTG.getClayColourMetasFromConfigString(config.getString("Savanna Clay Colours", "Plateaus", savannaClayColourString, ConfigRTG.getPlateauClayColourComment("Savanna biome variants")));
            stoneSavannas = config.getBoolean("Use stone instead of clay for most Savanna biome variants", "Plateaus", stoneSavannas, "If set to TRUE, Savanna biome variants will mostly use stone/cobblestone instead of stained hardened clay for cliffs and plateaus." + Configuration.NEW_LINE + "Savanna Plateau M will always use stained hardened clay." + Configuration.NEW_LINE);
            enableRavineModifications = config.getBoolean("Enable Ravine Modifications", "Ravines", enableRavineModifications, "Must be set to TRUE for the other ravine settings to have any effect." + Configuration.NEW_LINE + "If FALSE, RTG won't interfere with ravine generation at all." + Configuration.NEW_LINE);
            enableRavines = config.getBoolean("Enable Ravines", "Ravines", enableRavines, "");
            ravineFrequency = config.getInt("Ravine Frequency", "Ravines", ravineFrequency, 1, 100, "This setting controls the number of ravines that generate." + Configuration.NEW_LINE + "LOWER values = MORE ravines & MORE lag. (50 = vanilla ravine frequency)" + Configuration.NEW_LINE);
            enableRTGSaplings = config.getBoolean("Enable RTG Saplings", "Saplings", enableRTGSaplings, "Set this to TRUE to allow RTG's custom trees to grow from vanilla saplings." + Configuration.NEW_LINE + "RTG's custom trees can be grown only from the saplings that their leaves would drop naturally, and only in the biomes where they naturally generate." + Configuration.NEW_LINE + "For example, you can only grow a Swamp Willow in a Swamp biome, and only with an Oak sapling (because Swamp Willows have Oak leaves)." + Configuration.NEW_LINE);
            rtgTreeChance = config.getInt("RTG Tree from Vanilla Sapling Chance", "Saplings", rtgTreeChance, 1, Integer.MAX_VALUE, "1/x chance that a vanilla sapling will grow one of RTG's custom trees." + Configuration.NEW_LINE + "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            enableScatteredFeatureModifications = config.getBoolean("Enable Scattered Feature Modifications", "Scattered Features", enableScatteredFeatureModifications, "Must be set to TRUE for the other scattered feature settings to have any effect." + Configuration.NEW_LINE + "If FALSE, RTG won't interfere with scattered feature generation at all." + Configuration.NEW_LINE);
            generateScatteredFeatures = config.getBoolean("Generate Scattered Features", "Scattered Features", generateScatteredFeatures, "");
            minDistanceScatteredFeatures = config.getInt("Minimum distance between scattered features", "Scattered Features", minDistanceScatteredFeatures, 1, Integer.MAX_VALUE, "Scattered features = desert temples, jungle temples, and witch huts; 8 = Vanilla" + Configuration.NEW_LINE);
            maxDistanceScatteredFeatures = config.getInt("Maximum distance between scattered features", "Scattered Features", maxDistanceScatteredFeatures, 1, Integer.MAX_VALUE, "Scattered features = desert temples, jungle temples, and witch huts; 32 = Vanilla" + Configuration.NEW_LINE);
            enableSnowLayers = config.getBoolean("Enable Snow Layers", "Snow", enableSnowLayers, "This applies to newly-generated chunks only. Snow layers will still appear in cold/snowy biomes after it snows." + Configuration.NEW_LINE);
            generateStrongholds = config.getBoolean("Generate Strongholds", "Strongholds", generateStrongholds, "");
            shadowStoneBlockId = config.getString("Stone shadow block ID", "Terrain shadowing", shadowStoneBlockId, "The block to use for stone terrain shadowing, typically seen on the cliffs of stone mountains. Defaults to stained hardened clay." + Configuration.NEW_LINE);
            shadowStoneBlockByte = config.getInt("Stone shadow block meta value", "Terrain shadowing", shadowStoneBlockByte, 0, 15, "The meta value of the shadow block for stone cliffs. Defaults to " + shadowStoneBlockByte + " (cyan)." + Configuration.NEW_LINE);
            shadowDesertBlockId = config.getString("Desert shadow block ID", "Terrain shadowing", shadowDesertBlockId, "The block to use for desert terrain shadowing, typically seen on the cliffs of desert mountains. Defaults to stained hardened clay." + Configuration.NEW_LINE);
            shadowDesertBlockByte = config.getInt("Desert shadow block meta value", "Terrain shadowing", shadowDesertBlockByte, 0, 15, "The meta value of the shadow block for desert cliffs. Defaults to " + shadowDesertBlockByte + " (white)." + Configuration.NEW_LINE);
            enableUBCStoneShadowing = config.getBoolean("UBC Mode (Stone)", "Terrain shadowing", enableUBCStoneShadowing, "Set this to TRUE to allow UBC to override stone shadowing." + Configuration.NEW_LINE + "This setting doesn't have any effect if UBC is not installed." + Configuration.NEW_LINE);
            enableUBCDesertShadowing = config.getBoolean("UBC Mode (Desert)", "Terrain shadowing", enableUBCDesertShadowing, "Set this to TRUE to allow UBC to override desert shadowing." + Configuration.NEW_LINE + "This setting doesn't have any effect if UBC is not installed." + Configuration.NEW_LINE);
            allowTreesToGenerateOnSand = config.getBoolean("Allow Trees to Generate on Sand", "Trees", allowTreesToGenerateOnSand, "Set this to FALSE to prevent trees from generating on sand." + Configuration.NEW_LINE + "This setting only affects trees generated by RTG. Trees generated by a biome's decorator" + Configuration.NEW_LINE + "will adhere to their own generation rules. (RTG's Palm Trees ignore this setting.)" + Configuration.NEW_LINE);
            allowShrubsToGenerateBelowSurface = config.getBoolean("Allow Shrubs to Generate Below Surface", "Trees", allowShrubsToGenerateBelowSurface, "Set this to FALSE to prevent shrub trunks from generating below the surface." + Configuration.NEW_LINE);
            enableVillageModifications = config.getBoolean("Enable village modifications", "Villages", enableVillageModifications, "Set this to FALSE to resolve issues with mods that also modify villages." + Configuration.NEW_LINE + "If set to FALSE, the 'Minimum distance between villages', 'Maximum distance between villages' & 'Size of villages' settings will have no effect." + Configuration.NEW_LINE);
            generateVillages = config.getBoolean("Generate Villages", "Villages", generateVillages, "");
            villageSize = config.getInt("Size of villages", "Villages", villageSize, 0, 10, "Higher values = bigger villages; 0 = Vanilla" + Configuration.NEW_LINE);
            minDistanceVillages = config.getInt("Minimum distance between villages", "Villages", minDistanceVillages, 1, Integer.MAX_VALUE, "Higher values = villages further apart; 8 = Vanilla" + Configuration.NEW_LINE);
            maxDistanceVillages = config.getInt("Maximum distance between villages", "Villages", maxDistanceVillages, 1, Integer.MAX_VALUE, "Lower values = villages closer together; 32 = Vanilla" + Configuration.NEW_LINE);
            villageCrashFix = config.getBoolean("Village Crash Fix", "Villages", villageCrashFix, "Set this to TRUE to if you are experiencing 'java.util.ConcurrentModificationException' crashes related to village generation." + Configuration.NEW_LINE + "Defaults to FALSE unless EnviroMine is installed, in which case it defaults to TRUE." + Configuration.NEW_LINE);
            ConfigRTG.setVolcanoBlockDefaults();
            volcanoBlockId = config.getString("Volcano block ID", "Volcanoes", volcanoBlockId, "The main block to use for the surface of the volcano." + Configuration.NEW_LINE);
            volcanoBlockMeta = config.getInt("Volcano block meta value", "Volcanoes", volcanoBlockMeta, 0, 15, "The meta value of the volcano block." + Configuration.NEW_LINE);
            volcanoMix1BlockId = config.getString("Volcano mix 1 block ID", "Volcanoes", volcanoMix1BlockId, "The block ID of the 1st volcano mix block." + Configuration.NEW_LINE);
            volcanoMix1BlockMeta = config.getInt("Volcano mix 1 block meta value", "Volcanoes", volcanoMix1BlockMeta, 0, 15, "The meta value of the 1st volcano mix block." + Configuration.NEW_LINE);
            volcanoMix2BlockId = config.getString("Volcano mix 2 block ID", "Volcanoes", volcanoMix2BlockId, "The block ID of the 2nd volcano mix block." + Configuration.NEW_LINE);
            volcanoMix2BlockMeta = config.getInt("Volcano mix 2 block meta value", "Volcanoes", volcanoMix2BlockMeta, 0, 15, "The meta value of the 2nd volcano mix block." + Configuration.NEW_LINE);
            volcanoMix3BlockId = config.getString("Volcano mix 3 block ID", "Volcanoes", volcanoMix3BlockId, "The block ID of the 3rd volcano mix block." + Configuration.NEW_LINE);
            volcanoMix3BlockMeta = config.getInt("Volcano mix 3 block meta value", "Volcanoes", volcanoMix3BlockMeta, 0, 15, "The meta value of the 3rd volcano mix block." + Configuration.NEW_LINE);
            enableVolcanoes = config.getBoolean("Enable volcanoes", "Volcanoes", enableVolcanoes, "Set this to FALSE to prevent volcanoes from generating." + Configuration.NEW_LINE);
            enableVolcanoEruptions = config.getBoolean("Enable volcano eruptions", "Volcanoes", enableVolcanoEruptions, "Set this to FALSE to prevent lava from flowing down the sides of volcanoes." + Configuration.NEW_LINE);
            volcanoChance = config.getInt("Volcano Chance", "Volcanoes", volcanoChance, 1, Integer.MAX_VALUE, "1/x chance that a volcano will generate in a biome that has volcanoes enabled." + Configuration.NEW_LINE + "1 = Always generate if possible; 2 = 50% chance; 4 = 25% chance" + Configuration.NEW_LINE);
            riverSizeMultiplier = config.getFloat("River Width Multipler", riversAndLakes, 1.0f, 0.0f, 10.0f, "Defaults to 1 (standard width)" + Configuration.NEW_LINE);
            riverFrequencyMultiplier = config.getFloat("River Frequency Multiplier", riversAndLakes, 1.0f, 0.0f, 10.0f, "Multiplier to river widths. Defaults to 1" + Configuration.NEW_LINE);
            riverBendinessMultiplier = config.getFloat("Multiplier to River Bending", riversAndLakes, 1.0f, 0.0f, 2.0f, "Higher numbers make rivers bend more. Defaults to 1" + Configuration.NEW_LINE);
            riverCutOffScale = config.getFloat("Scale of Large-Scale River Cut Off", riversAndLakes, 350.0f, 50.0f, 5000.0f, "Higher numbers make grassy areas near rivers bigger, but also more rare. Defaults to 350" + Configuration.NEW_LINE);
            riverCutOffAmplitude = config.getFloat("Amplitude of Large-Scale River Cut Off", riversAndLakes, 0.5f, 0.0f, 2.0f, "Higher numbers make the large-scale cut-off noise have a greater effect. Defaults to 0.5" + Configuration.NEW_LINE);
            lakeSizeMultiplier = config.getFloat("Lake Size Multipler", riversAndLakes, 1.0f, 0.0f, 10.0f, "Defaults to 1 (standard size)" + Configuration.NEW_LINE);
            lakeFrequencyMultiplier = config.getFloat("Lake Frequency Multipler", riversAndLakes, 1.0f, 0.0f, 10.0f, "Defaults to 1 (standard frequency)" + Configuration.NEW_LINE);
            lakeShoreBendinessMultiplier = config.getFloat("Lake Shore Irregularity", riversAndLakes, 1.0f, 0.0f, 2.0f, "Makes scenic lake shores bend and curve more. Defaults to 1" + Configuration.NEW_LINE);
            scenicLakeBiome = config.getInt("Biome for scenic lakes", riversAndLakes, 7, 0, 254, "Biome ID for scenic lakes when not frozen (default 7 = River)" + Configuration.NEW_LINE);
            scenicFrozenLakeBiome = config.getInt("Biome for frozen scenic lakes", riversAndLakes, 11, 0, 254, "Biome ID for scenic lakes when frozen (default 11 = Frozen River)" + Configuration.NEW_LINE);
        }
        catch (Exception e) {
            Logger.error("RTG has had a problem loading RTG configuration.", new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static boolean enableVillageTweaks() {
        boolean enableVillageModifications = true;
        return enableVillageModifications;
    }

    private static byte[] getClayColourMetasFromConfigString(String configString) {
        String[] strings = configString.split(",");
        ArrayList<Byte> byteList = new ArrayList<Byte>(){};
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
            if (!strings[i].matches("-1|0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15")) continue;
            byteList.add(Byte.valueOf(strings[i]));
        }
        Byte[] bytes = byteList.toArray(new Byte[byteList.size()]);
        return ArrayUtils.toPrimitive((Byte[])bytes);
    }

    private static String getPlateauClayColourComment(String biomeName) {
        String comment = "Comma-separated list of meta values for the clay blocks used in the " + biomeName + "." + Configuration.NEW_LINE + "-1 = Hardened Clay; 0-15 = Stained Clay" + Configuration.NEW_LINE + "0 = White; 1 = Orange; 2 = Magenta; 3 = Light Blue; 4 = Yellow; 5 = Lime; 6 = Pink; 7 = Gray" + Configuration.NEW_LINE + "8 = Light Gray; 9 = Cyan; 10 = Purple; 11 = Blue; 12 = Brown; 13 = Green; 14 = Red; 15 = Black" + Configuration.NEW_LINE;
        return comment;
    }

    private static void setVolcanoBlockDefaults() {
        ModPresenceTester bopMod = new ModPresenceTester("BiomesOPlenty");
        ModPresenceTester ebMod = new ModPresenceTester("enhancedbiomes");
        ModPresenceTester ubcMod = new ModPresenceTester("UndergroundBiomes");
        volcanoBlockId = "minecraft:obsidian";
        volcanoBlockMeta = 0;
        volcanoMix1BlockId = "minecraft:cobblestone";
        volcanoMix1BlockMeta = 0;
        volcanoMix2BlockId = "minecraft:gravel";
        volcanoMix2BlockMeta = 0;
        volcanoMix3BlockId = "minecraft:coal_block";
        volcanoMix3BlockMeta = 0;
        if (bopMod.present()) {
            volcanoMix1BlockId = "BiomesOPlenty:ashStone";
            volcanoMix1BlockMeta = 0;
            volcanoMix2BlockId = "BiomesOPlenty:ash";
            volcanoMix2BlockMeta = 0;
        } else if (ebMod.present()) {
            volcanoMix1BlockId = "enhancedbiomes:enhancedbiomes.tile.stoneCobbleEB";
            volcanoMix1BlockMeta = 0;
            volcanoMix2BlockId = "enhancedbiomes:enhancedbiomes.tile.stoneEB";
            volcanoMix2BlockMeta = 0;
        } else if (ubcMod.present()) {
            volcanoMix1BlockId = "UndergroundBiomes:igneousCobblestone";
            volcanoMix1BlockMeta = 5;
            volcanoMix2BlockId = "UndergroundBiomes:igneousStone";
            volcanoMix2BlockMeta = 5;
        }
    }

    static {
        flatBedrockLayers = 0;
        bedrockBlockId = "minecraft:bedrock";
        bedrockBlockByte = 0;
        enableRTGBiomeDecorations = true;
        enableRTGBiomeSurfaces = true;
        patchBiomeId = 1;
        enableCobblestoneBoulders = true;
        cobblestoneBoulderChance = 1;
        enableUBCBoulders = true;
        enableCaveModifications = true;
        enableCaves = true;
        caveDensity = 8;
        caveFrequency = 16;
        duneHeight = 4;
        enableDebugging = false;
        generateDungeons = true;
        dungeonFrequency = 8;
        flowingWaterChance = 200;
        flowingLavaChance = 200;
        enableWaterSurfaceLakes = true;
        waterSurfaceLakeChance = 10;
        enableLavaSurfaceLakes = true;
        lavaSurfaceLakeChance = 10;
        enableWaterUndergroundLakes = true;
        waterUndergroundLakeChance = 10;
        enableLavaUndergroundLakes = true;
        lavaUndergroundLakeChance = 10;
        generateMineshafts = true;
        generateOreCoal = true;
        generateOreIron = true;
        generateOreGold = true;
        generateOreRedstone = true;
        generateOreLapis = true;
        generateOreDiamond = true;
        generateOreEmerald = true;
        mesaClayColourString = "-1,-1,-1,1,1,1,0,-1,-1,6,1,1,8,0,-1,-1,14,-1,-1,6,1,1,4";
        mesaBryceClayColourString = "-1,-1,0,1,0,0,0,14,0,8,0,1,8,0,-1,0,14,0,0,14,0,0,8";
        savannaClayColourString = "0,0,0,0,8,8,12,12,8,0,8,12,12,8,12,8,0,0,8,12,12";
        mesaClayColours = ConfigRTG.getClayColourMetasFromConfigString(mesaClayColourString);
        mesaBryceClayColours = ConfigRTG.getClayColourMetasFromConfigString(mesaBryceClayColourString);
        savannaClayColours = ConfigRTG.getClayColourMetasFromConfigString(savannaClayColourString);
        stoneSavannas = true;
        enableRavineModifications = true;
        enableRavines = false;
        ravineFrequency = 50;
        enableRTGSaplings = true;
        rtgTreeChance = 2;
        enableScatteredFeatureModifications = true;
        generateScatteredFeatures = true;
        minDistanceScatteredFeatures = 12;
        maxDistanceScatteredFeatures = 48;
        enableSnowLayers = true;
        generateStrongholds = true;
        shadowStoneBlockId = "minecraft:stained_hardened_clay";
        shadowStoneBlockByte = 9;
        shadowDesertBlockId = "minecraft:stained_hardened_clay";
        shadowDesertBlockByte = 0;
        enableUBCStoneShadowing = true;
        enableUBCDesertShadowing = true;
        allowTreesToGenerateOnSand = true;
        allowShrubsToGenerateBelowSurface = true;
        generateVillages = true;
        enableVillageModifications = ConfigRTG.enableVillageTweaks();
        villageSize = 0;
        minDistanceVillages = 12;
        maxDistanceVillages = 48;
        villageCrashFix = Loader.isModLoaded((String)"enviromine");
        enableVolcanoes = true;
        enableVolcanoEruptions = true;
        volcanoChance = 36;
        riverSizeMultiplier = 1.0f;
        riverFrequencyMultiplier = 1.0f;
        riverBendinessMultiplier = 1.0f;
        riverCutOffScale = 350.0f;
        riverCutOffAmplitude = 0.5f;
        lakeSizeMultiplier = 1.0f;
        lakeFrequencyMultiplier = 1.0f;
        lakeShoreBendinessMultiplier = 1.0f;
        scenicLakeBiome = 7;
        scenicFrozenLakeBiome = 11;
        riversAndLakes = "Rivers and Scenic Lakes";
    }
}

