/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.IHeatTransfer;
import mekanism.api.transmitters.ITransmitterTile;
import net.minecraftforge.common.util.ForgeDirection;

public class HeatUtils {
    public static double[] simulate(IHeatTransfer source) {
        double[] heatTransferred = new double[]{0.0, 0.0};
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            double heatToTransfer;
            double invConduction;
            IHeatTransfer sink = source.getAdjacent(side);
            if (sink != null) {
                invConduction = sink.getInverseConductionCoefficient() + source.getInverseConductionCoefficient();
                heatToTransfer = source.getTemp() / invConduction;
                source.transferHeatTo(-heatToTransfer);
                sink.transferHeatTo(heatToTransfer);
                if (sink instanceof ITransmitterTile) continue;
                heatTransferred[0] = heatTransferred[0] + heatToTransfer;
                continue;
            }
            invConduction = 10000.0 + source.getInsulationCoefficient(side) + source.getInverseConductionCoefficient();
            heatToTransfer = source.getTemp() / invConduction;
            source.transferHeatTo(-heatToTransfer);
            heatTransferred[1] = heatTransferred[1] + heatToTransfer;
        }
        return heatTransferred;
    }
}

