/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.security;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.HashList;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.ISecurityTile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class SecurityFrequency
extends Frequency {
    public static final String SECURITY = "Security";
    public boolean override;
    public HashList<String> trusted;
    public ISecurityTile.SecurityMode securityMode;

    public SecurityFrequency(String o) {
        super(SECURITY, o);
        this.trusted = new HashList();
        this.securityMode = ISecurityTile.SecurityMode.PUBLIC;
    }

    public SecurityFrequency(NBTTagCompound nbtTags) {
        super(nbtTags);
    }

    public SecurityFrequency(ByteBuf dataStream) {
        super(dataStream);
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74757_a("override", this.override);
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        if (!this.trusted.isEmpty()) {
            NBTTagList trustedList = new NBTTagList();
            for (String s : this.trusted) {
                trustedList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            nbtTags.func_74782_a("trusted", (NBTBase)trustedList);
        }
    }

    @Override
    protected void read(NBTTagCompound nbtTags) {
        super.read(nbtTags);
        this.trusted = new HashList();
        this.securityMode = ISecurityTile.SecurityMode.PUBLIC;
        this.override = nbtTags.func_74767_n("override");
        this.securityMode = ISecurityTile.SecurityMode.values()[nbtTags.func_74762_e("securityMode")];
        if (nbtTags.func_74764_b("trusted")) {
            NBTTagList trustedList = nbtTags.func_150295_c("trusted", 8);
            for (int i = 0; i < trustedList.func_74745_c(); ++i) {
                this.trusted.add(trustedList.func_150307_f(i));
            }
        }
    }

    @Override
    public void write(ArrayList data) {
        super.write(data);
        data.add(this.override);
        data.add(this.securityMode.ordinal());
        data.add(this.trusted.size());
        for (String s : this.trusted) {
            data.add(s);
        }
    }

    @Override
    protected void read(ByteBuf dataStream) {
        super.read(dataStream);
        this.trusted = new HashList();
        this.securityMode = ISecurityTile.SecurityMode.PUBLIC;
        this.override = dataStream.readBoolean();
        this.securityMode = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        this.trusted.clear();
        int size = dataStream.readInt();
        for (int i = 0; i < size; ++i) {
            this.trusted.add(PacketHandler.readString(dataStream));
        }
    }
}

