/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Tier;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartThermodynamicConductor;
import mekanism.common.multipart.PartUniversalCable;
import mekanism.common.multipart.TransmitterIcons;
import net.minecraft.util.IIcon;

public enum TransmitterType {
    UNIVERSAL_CABLE_BASIC("BasicUniversalCable", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.ENERGY, PartUniversalCable.cableIcons, false, 0, 0),
    UNIVERSAL_CABLE_ADVANCED("AdvancedUniversalCable", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.ENERGY, PartUniversalCable.cableIcons, false, 1, 1),
    UNIVERSAL_CABLE_ELITE("EliteUniversalCable", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.ENERGY, PartUniversalCable.cableIcons, false, 2, 2),
    UNIVERSAL_CABLE_ULTIMATE("UltimateUniversalCable", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.ENERGY, PartUniversalCable.cableIcons, false, 3, 3),
    MECHANICAL_PIPE_BASIC("BasicMechanicalPipe", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.FLUID, PartMechanicalPipe.pipeIcons, false, 0, 0),
    MECHANICAL_PIPE_ADVANCED("AdvancedMechanicalPipe", Tier.BaseTier.ADVANCED, Size.LARGE, TransmissionType.FLUID, PartMechanicalPipe.pipeIcons, false, 1, 1),
    MECHANICAL_PIPE_ELITE("EliteMechanicalPipe", Tier.BaseTier.ELITE, Size.LARGE, TransmissionType.FLUID, PartMechanicalPipe.pipeIcons, false, 2, 2),
    MECHANICAL_PIPE_ULTIMATE("UltimateMechanicalPipe", Tier.BaseTier.ULTIMATE, Size.LARGE, TransmissionType.FLUID, PartMechanicalPipe.pipeIcons, false, 3, 3),
    PRESSURIZED_TUBE_BASIC("BasicPressurizedTube", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.GAS, PartPressurizedTube.tubeIcons, false, 0, 0),
    PRESSURIZED_TUBE_ADVANCED("AdvancedPressurizedTube", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.GAS, PartPressurizedTube.tubeIcons, false, 1, 1),
    PRESSURIZED_TUBE_ELITE("ElitePressurizedTube", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.GAS, PartPressurizedTube.tubeIcons, false, 2, 2),
    PRESSURIZED_TUBE_ULTIMATE("UltimatePressurizedTube", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.GAS, PartPressurizedTube.tubeIcons, false, 3, 3),
    LOGISTICAL_TRANSPORTER_BASIC("BasicLogisticalTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, true, 0, 0, 6, 10),
    LOGISTICAL_TRANSPORTER_ADVANCED("AdvancedLogisticalTransporter", Tier.BaseTier.ADVANCED, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, true, 1, 1, 6, 10),
    LOGISTICAL_TRANSPORTER_ELITE("EliteLogisticalTransporter", Tier.BaseTier.ELITE, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, true, 2, 2, 6, 10),
    LOGISTICAL_TRANSPORTER_ULTIMATE("UltimateLogisticalTransporter", Tier.BaseTier.ULTIMATE, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, true, 3, 3, 6, 10),
    RESTRICTIVE_TRANSPORTER("RestrictiveTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, false, 4, 8),
    DIVERSION_TRANSPORTER("DiversionTransporter", Tier.BaseTier.BASIC, Size.LARGE, TransmissionType.ITEM, PartLogisticalTransporter.transporterIcons, true, 5, 14, 6, 10),
    THERMODYNAMIC_CONDUCTOR_BASIC("BasicThermodynamicConductor", Tier.BaseTier.BASIC, Size.SMALL, TransmissionType.HEAT, PartThermodynamicConductor.conductorIcons, false, 0, 0),
    THERMODYNAMIC_CONDUCTOR_ADVANCED("AdvancedThermodynamicConductor", Tier.BaseTier.ADVANCED, Size.SMALL, TransmissionType.HEAT, PartThermodynamicConductor.conductorIcons, false, 1, 1),
    THERMODYNAMIC_CONDUCTOR_ELITE("EliteThermodynamicConductor", Tier.BaseTier.ELITE, Size.SMALL, TransmissionType.HEAT, PartThermodynamicConductor.conductorIcons, false, 2, 2),
    THERMODYNAMIC_CONDUCTOR_ULTIMATE("UltimateThermodynamicConductor", Tier.BaseTier.ULTIMATE, Size.SMALL, TransmissionType.HEAT, PartThermodynamicConductor.conductorIcons, false, 3, 3);

    private String unlocalizedName;
    private Size size;
    private TransmissionType transmissionType;
    private TransmitterIcons transmitterIcons;
    private boolean transparencyRender;
    private int[] indexes;
    private Tier.BaseTier tier;

    private TransmitterType(String name, Tier.BaseTier t, Size s, TransmissionType type, TransmitterIcons icons, boolean transparency, int ... is) {
        this.unlocalizedName = name;
        this.tier = t;
        this.size = s;
        this.transmissionType = type;
        this.transmitterIcons = icons;
        this.transparencyRender = transparency;
        this.indexes = is;
    }

    public Tier.BaseTier getTier() {
        return this.tier;
    }

    public String getName() {
        return this.unlocalizedName;
    }

    public Size getSize() {
        return this.size;
    }

    public boolean hasTransparency() {
        return this.transparencyRender;
    }

    public TransmissionType getTransmission() {
        return this.transmissionType;
    }

    public IIcon getCenterIcon(boolean opaque) {
        if (!this.transparencyRender) {
            return this.transmitterIcons.getCenterIcon(this.indexes[0]);
        }
        return this.transmitterIcons.getCenterIcon(opaque ? this.indexes[0] : this.indexes[2]);
    }

    public IIcon getSideIcon(boolean opaque) {
        if (!this.transparencyRender) {
            return this.transmitterIcons.getSideIcon(this.indexes[1]);
        }
        return this.transmitterIcons.getSideIcon(opaque ? this.indexes[1] : this.indexes[3]);
    }

    public static enum Size {
        SMALL(6),
        LARGE(8);

        public int centerSize;

        private Size(int size) {
            this.centerSize = size;
        }
    }
}

