/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySource;
import java.util.Collection;
import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.EnergyStack;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.Tier;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PartUniversalCable
extends PartTransmitter<EnergyAcceptorWrapper, EnergyNetwork>
implements IStrictEnergyAcceptor,
IEnergyHandler {
    public Tier.CableTier tier;
    public static TransmitterIcons cableIcons = new TransmitterIcons(4, 8);
    public double currentPower = 0.0;
    public double lastWrite = 0.0;
    public EnergyStack buffer = new EnergyStack(0.0);

    public PartUniversalCable(Tier.CableTier cableTier) {
        this.tier = cableTier;
    }

    @Override
    public void update() {
        if (this.world().field_72995_K) {
            double targetPower;
            double d = targetPower = ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() ? ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).clientEnergyScale : 0.0;
            if (Math.abs(this.currentPower - targetPower) > 0.01) {
                this.currentPower = (9.0 * this.currentPower + targetPower) / 10.0;
            }
        } else {
            this.updateShare();
            List<ForgeDirection> sides = this.getConnections(PartSidedPipe.ConnectionType.PULL);
            if (!sides.isEmpty()) {
                TileEntity[] connectedOutputters = CableUtils.getConnectedOutputters((TileEntity)this.tile());
                double canDraw = (float)this.tier.cableCapacity / 10.0f;
                for (ForgeDirection side : sides) {
                    double toDraw;
                    double received;
                    if (connectedOutputters[side.ordinal()] == null) continue;
                    TileEntity outputter = connectedOutputters[side.ordinal()];
                    if (outputter instanceof ICableOutputter && outputter instanceof IStrictEnergyStorage) {
                        if (!((ICableOutputter)outputter).canOutputTo(side.getOpposite())) continue;
                        toDraw = received = Math.min(((IStrictEnergyStorage)outputter).getEnergy(), canDraw);
                        if (received > 0.0) {
                            toDraw -= this.takeEnergy(received, true);
                        }
                        ((IStrictEnergyStorage)outputter).setEnergy(((IStrictEnergyStorage)outputter).getEnergy() - toDraw);
                        continue;
                    }
                    if (MekanismUtils.useRF() && outputter instanceof IEnergyProvider) {
                        toDraw = received = (double)((IEnergyProvider)outputter).extractEnergy(side.getOpposite(), (int)(canDraw * MekanismConfig.general.TO_TE), true) * MekanismConfig.general.FROM_TE;
                        if (received > 0.0) {
                            toDraw -= this.takeEnergy(received, true);
                        }
                        ((IEnergyProvider)outputter).extractEnergy(side.getOpposite(), (int)(toDraw * MekanismConfig.general.TO_TE), false);
                        continue;
                    }
                    if (!MekanismUtils.useIC2() || !(outputter instanceof IEnergySource)) continue;
                    toDraw = received = Math.min(((IEnergySource)outputter).getOfferedEnergy() * MekanismConfig.general.FROM_IC2, canDraw);
                    if (received > 0.0) {
                        toDraw -= this.takeEnergy(received, true);
                    }
                    ((IEnergySource)outputter).drawEnergy(toDraw * MekanismConfig.general.TO_IC2);
                }
            }
        }
        super.update();
    }

    @Override
    public void updateShare() {
        double last;
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((Transmitter)this.getTransmitter()).getTransmitterNetworkSize() > 0 && (last = this.getSaveShare()) != this.lastWrite) {
            this.lastWrite = last;
            MekanismUtils.saveChunk((TileEntity)this.tile());
        }
    }

    private double getSaveShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return EnergyNetwork.round(((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount * (double)(1.0f / (float)((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size()));
        }
        return this.buffer.amount;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.buffer.amount = nbtTags.func_74769_h("cacheEnergy");
        if (this.buffer.amount < 0.0) {
            this.buffer.amount = 0.0;
        }
        this.tier = Tier.CableTier.values()[nbtTags.func_74762_e("tier")];
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("cacheEnergy", this.lastWrite);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:universal_cable_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        cableIcons.registerCenterIcons(register, new String[]{"UniversalCableBasic", "UniversalCableAdvanced", "UniversalCableElite", "UniversalCableUltimate"});
        cableIcons.registerSideIcons(register, new String[]{"UniversalCableVerticalBasic", "UniversalCableVerticalAdvanced", "UniversalCableVerticalElite", "UniversalCableVerticalUltimate", "UniversalCableHorizontalBasic", "UniversalCableHorizontalAdvanced", "UniversalCableHorizontalElite", "UniversalCableHorizontalUltimate"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return cableIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return cableIcons.getSideIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return cableIcons.getSideIcon(4 + this.tier.ordinal());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkByMerging(Collection<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, ForgeDirection side) {
        return CableUtils.isValidAcceptorOnSide((TileEntity)this.tile(), acceptor, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 && !MekanismConfig.client.opaqueTransmitters) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public EnergyNetwork createNewNetwork() {
        return new EnergyNetwork();
    }

    @Override
    public void onChunkUnload() {
        this.takeShare();
        super.onChunkUnload();
    }

    @Override
    public Object getBuffer() {
        return this.buffer;
    }

    @Override
    public void takeShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite;
            this.buffer.amount = this.lastWrite;
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.canReceiveEnergy(from)) {
            return maxReceive - (int)Math.round(this.takeEnergy((double)maxReceive * MekanismConfig.general.FROM_TE, !simulate) * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.canConnect(from);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getCapacity() {
        return this.tier.cableCapacity;
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getMaxEnergy() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).getCapacity();
        }
        return this.getCapacity();
    }

    @Override
    public double getEnergy() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount;
        }
        return this.buffer.amount;
    }

    @Override
    public void setEnergy(double energy) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount = energy;
        } else {
            this.buffer.amount = energy;
        }
    }

    public double takeEnergy(double energy, boolean doEmit) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((EnergyNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).emit(energy, doEmit);
        }
        double used = Math.min((double)this.getCapacity() - this.buffer.amount, energy);
        if (doEmit) {
            this.buffer.amount += used;
        }
        return energy - used;
    }

    @Override
    public EnergyAcceptorWrapper getCachedAcceptor(ForgeDirection side) {
        PartSidedPipe.ConnectionType type = this.connectionTypes[side.ordinal()];
        if (type == PartSidedPipe.ConnectionType.PULL || type == PartSidedPipe.ConnectionType.NONE) {
            return null;
        }
        return PartUniversalCable.connectionMapContainsSide(this.currentAcceptorConnections, side) ? EnergyAcceptorWrapper.get(this.cachedAcceptors[side.ordinal()]) : null;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.CableTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.tier = Tier.CableTier.values()[packet.readInt()];
        super.readDesc(packet);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeDesc(packet);
    }
}

