/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismConfig;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.HeatNetwork;
import mekanism.common.Tier;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.HeatUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PartThermodynamicConductor
extends PartTransmitter<IHeatTransfer, HeatNetwork>
implements IHeatTransfer {
    public Tier.ConductorTier tier;
    public static TransmitterIcons conductorIcons = new TransmitterIcons(4, 8);
    public double temperature = 0.0;
    public double clientTemperature = 0.0;
    public double heatToAbsorb = 0.0;

    public PartThermodynamicConductor(Tier.ConductorTier conductorTier) {
        this.tier = conductorTier;
    }

    @Override
    public HeatNetwork createNewNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    public static void registerIcons(IIconRegister register) {
        conductorIcons.registerCenterIcons(register, new String[]{"ThermodynamicConductorBasic", "ThermodynamicConductorAdvanced", "ThermodynamicConductorElite", "ThermodynamicConductorUltimate"});
        conductorIcons.registerSideIcons(register, new String[]{"ThermodynamicConductorVerticalBasic", "ThermodynamicConductorVerticalAdvanced", "ThermodynamicConductorVerticalElite", "ThermodynamicConductorVerticalUltimate", "ThermodynamicConductorHorizontalBasic", "ThermodynamicConductorHorizontalAdvanced", "ThermodynamicConductorHorizontalElite", "ThermodynamicConductorHorizontalUltimate"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return conductorIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return conductorIcons.getSideIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return conductorIcons.getSideIcon(4 + this.tier.ordinal());
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return tile instanceof IHeatTransfer && ((IHeatTransfer)tile).canConnectHeat(side.getOpposite());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    public String getType() {
        return "mekanism:thermodynamic_conductor_" + this.tier.name().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0 && !MekanismConfig.client.opaqueTransmitters) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.temperature = nbtTags.func_74769_h("temperature");
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74780_a("temperature", this.temperature);
    }

    public void sendTemp() {
        MCDataOutput packet = this.getWriteStream();
        packet.writeBoolean(true);
        packet.writeDouble(this.temperature);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeBoolean(false);
        super.writeDesc(packet);
        packet.writeInt(this.tier.ordinal());
    }

    @Override
    public void readDesc(MCDataInput packet) {
        if (packet.readBoolean()) {
            this.temperature = packet.readDouble();
        } else {
            super.readDesc(packet);
            this.tier = Tier.ConductorTier.values()[packet.readInt()];
        }
    }

    public ColourRGBA getBaseColour() {
        return this.tier.baseColour;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return this.tier.inverseConduction;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return this.tier.inverseConductionInsulation;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.tier.inverseHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        if (Math.abs(this.temperature - this.clientTemperature) > this.temperature / 100.0) {
            this.clientTemperature = this.temperature;
            this.sendTemp();
        }
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj;
        if (PartThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side) && (adj = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world())) instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.ConductorTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }
}

