/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import net.minecraftforge.common.util.ForgeDirection;

public class PathfinderCache {
    public static Map<PathData, List<Coord4D>> cachedPaths = new HashMap<PathData, List<Coord4D>>();

    public static void onChanged(Coord4D location) {
        PathfinderCache.reset();
    }

    public static List<Coord4D> getCache(Coord4D start, Coord4D end, EnumSet<ForgeDirection> sides) {
        List<Coord4D> ret = null;
        for (ForgeDirection side : sides) {
            PathData data = new PathData(start, end, side);
            List<Coord4D> test = cachedPaths.get(data);
            if (ret != null && (test == null || test.size() >= ret.size())) continue;
            ret = test;
        }
        return ret;
    }

    public static void reset() {
        cachedPaths.clear();
    }

    public static class PathData {
        public Coord4D startTransporter;
        public Coord4D end;
        public ForgeDirection endSide;

        public PathData(Coord4D s, Coord4D e, ForgeDirection es) {
            this.startTransporter = s;
            this.end = e;
            this.endSide = es;
        }

        public boolean equals(Object obj) {
            return obj instanceof PathData && ((PathData)obj).startTransporter.equals(this.startTransporter) && ((PathData)obj).end.equals(this.end) && ((PathData)obj).endSide.equals((Object)this.endSide);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.startTransporter.hashCode();
            code = 31 * code + this.end.hashCode();
            code = 31 * code + this.endSide.hashCode();
            return code;
        }
    }
}

