/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.client.sound.IResettableSound;
import mekanism.client.sound.Sound;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class PlayerSound
extends Sound
implements IResettableSound {
    public EntityPlayer player;
    boolean beginFadeOut;
    boolean donePlaying = true;
    int ticks = 0;
    int fadeIn;
    int fadeOut;
    float baseVolume = 0.3f;

    public PlayerSound(EntityPlayer p, ResourceLocation location) {
        super(location, 0.3f, 1.0f, true, 0, (double)((float)p.field_70165_t), (double)((float)p.field_70163_u), (double)((float)p.field_70161_v), ISound.AttenuationType.LINEAR);
        this.player = p;
    }

    @Override
    public float func_147649_g() {
        return (float)this.player.field_70165_t;
    }

    @Override
    public float func_147654_h() {
        return (float)this.player.field_70163_u;
    }

    @Override
    public float func_147651_i() {
        return (float)this.player.field_70161_v;
    }

    public PlayerSound setFadeIn(int fade) {
        this.fadeIn = Math.max(0, fade);
        return this;
    }

    public PlayerSound setFadeOut(int fade) {
        this.fadeOut = Math.max(0, fade);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void func_73660_a() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.shouldPlaySound()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.volume = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    public abstract boolean shouldPlaySound();

    @Override
    public void reset() {
        this.donePlaying = false;
        this.beginFadeOut = false;
        this.volume = this.baseVolume;
        this.ticks = 0;
    }
}

