/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiChemicalWasher;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.common.ObfuscatedNames;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ChemicalWasherRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;
    public static int xOffset = 5;
    public static int yOffset = 3;

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock2.ChemicalWasher.name");
    }

    public String getOverlayIdentifier() {
        return "chemicalwasher";
    }

    public String getGuiTexture() {
        return "mekanism:gui/nei/GuiChemicalWasher.png";
    }

    public Class getGuiClass() {
        return GuiChemicalWasher.class;
    }

    public String getRecipeId() {
        return "mekanism.chemicalwasher";
    }

    public Collection<WasherRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_WASHER.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-2, (int)0, (int)3, (int)yOffset, (int)170, (int)70);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        GuiDraw.drawTexturedModalRect((int)(61 - xOffset), (int)(39 - yOffset), (int)176, (int)63, (int)55, (int)8);
        this.displayGauge(58, 6 - xOffset, 5 - yOffset, 176, 4, 58, new FluidStack(FluidRegistry.WATER, 1), null);
        if (recipe.outputStack != null) {
            this.displayGauge(58, 27 - xOffset, 14 - yOffset, 176, 4, 58, null, recipe.inputStack);
        }
        if (recipe.inputStack != null) {
            this.displayGauge(58, 134 - xOffset, 14 - yOffset, 176, 4, 58, null, recipe.outputStack);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(61 - xOffset, 39 - yOffset, 55, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (WasherRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else if (outputId.equals("gas") && results.length == 1 && results[0] instanceof GasStack) {
            for (WasherRecipe irecipe : this.getRecipes()) {
                if (!((GasStack)results[0]).isGasEqual(((GasOutput)irecipe.getOutput()).output)) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluid") && ingredients.length == 1 && ingredients[0] instanceof FluidStack) {
            if (((FluidStack)ingredients[0]).getFluid() == FluidRegistry.WATER) {
                for (WasherRecipe irecipe : this.getRecipes()) {
                    this.arecipes.add(new CachedIORecipe(irecipe));
                }
            }
        } else if (inputId.equals("gas") && ingredients.length == 1 && ingredients[0] instanceof GasStack) {
            for (WasherRecipe irecipe : this.getRecipes()) {
                if (!((GasInput)irecipe.getInput()).ingredient.isGasEqual((GasStack)ingredients[0])) continue;
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            currenttip.add(FluidRegistry.WATER.getLocalizedName(null));
        } else if (xAxis >= 27 && xAxis <= 43 && yAxis >= 27 && yAxis <= 85) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack));
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            currenttip.add(LangUtils.localizeGasStack(((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack));
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            fluid = new FluidStack(FluidRegistry.WATER, 1);
        } else if (xAxis >= 27 && xAxis <= 43 && yAxis >= 27 && yAxis <= 85) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (gas != null ? (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doGasLookup(gas, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doGasLookup(gas, true)) : fluid != null && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.doFluidLookup(fluid, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point point = GuiDraw.getMousePosition();
        int xAxis = point.x - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiLeft);
        int yAxis = point.y - (Integer)MekanismUtils.getPrivateValue(gui, GuiContainer.class, ObfuscatedNames.GuiContainer_guiTop);
        GasStack gas = null;
        FluidStack fluid = null;
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 18 && yAxis <= 76) {
            fluid = new FluidStack(FluidRegistry.WATER, 1);
        } else if (xAxis >= 27 && xAxis <= 43 && yAxis >= 27 && yAxis <= 85) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).inputStack;
        } else if (xAxis >= 134 && xAxis <= 150 && yAxis >= 27 && yAxis <= 85) {
            gas = ((CachedIORecipe)((Object)this.arecipes.get((int)recipe))).outputStack;
        }
        if (gas != null ? (button == 0 ? this.doGasLookup(gas, false) : button == 1 && this.doGasLookup(gas, true)) : fluid != null && (button == 0 ? this.doFluidLookup(fluid, false) : button == 1 && this.doFluidLookup(fluid, true))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    @Override
    public void addGuiElements() {
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public GasStack inputStack;
        public GasStack outputStack;

        public PositionedStack getResult() {
            return null;
        }

        public CachedIORecipe(GasStack input, GasStack output) {
            super((TemplateRecipeHandler)ChemicalWasherRecipeHandler.this);
            this.inputStack = input;
            this.outputStack = output;
        }

        public CachedIORecipe(WasherRecipe recipe) {
            this(((GasInput)recipe.getInput()).ingredient, ((GasOutput)recipe.getOutput()).output);
        }
    }
}

