/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public class GuiSeismicReader
extends GuiScreen {
    private World worldObj;
    public ItemStack itemStack;
    private ArrayList<Pair<Integer, Block>> blockList = new ArrayList();
    public Coord4D pos;
    protected int xSize = 137;
    protected int ySize = 182;
    private Rectangle upButton;
    private Rectangle downButton;
    private Rectangle tooltip;
    private int currentLayer = 0;

    public GuiSeismicReader(World world, Coord4D coord, ItemStack stack) {
        this.pos = coord;
        this.pos.yCoord = Math.min(255, this.pos.yCoord);
        this.worldObj = world;
        this.itemStack = stack;
        this.calculate();
        this.currentLayer = Math.max(0, this.blockList.size() - 1);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.upButton = new Rectangle((this.field_146294_l - this.xSize) / 2 + 70, (this.field_146295_m - this.ySize) / 2 + 75, 13, 13);
        this.downButton = new Rectangle((this.field_146294_l - this.xSize) / 2 + 70, (this.field_146295_m - this.ySize) / 2 + 92, 13, 13);
        this.tooltip = new Rectangle((this.field_146294_l - this.xSize) / 2 + 30, (this.field_146295_m - this.ySize) / 2 + 82, 16, 16);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.xSize) / 2;
        int guiHeight = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSeismicReader.png"));
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.xSize, this.ySize);
        if (this.upButton.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.func_73729_b(this.upButton.getX(), this.upButton.getY(), 137, 0, this.upButton.getWidth(), this.upButton.getHeight());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.downButton.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)1.0f);
        }
        this.func_73729_b(this.downButton.getX(), this.downButton.getY(), 150, 0, this.downButton.getWidth(), this.downButton.getHeight());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(guiWidth + 48), (float)(guiHeight + 87), (float)0.0f);
        if (this.currentLayer >= 100) {
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        }
        this.field_146289_q.func_78276_b(String.format("%s", this.currentLayer), 0, 0, 0xAFAFAF);
        GL11.glPopMatrix();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            int centralX = guiWidth + 32;
            int centralY = guiHeight + 103;
            int layer = this.currentLayer + (i - 5);
            if (0 > layer || layer >= this.blockList.size() || (stack = new ItemStack((Block)this.blockList.get(layer).getRight(), 1, ((Integer)this.blockList.get(layer).getLeft()).intValue())).func_77973_b() == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(centralX - 2), (float)(centralY - i * 16 + 44), (float)0.0f);
            if (i < 4) {
                GL11.glTranslatef((float)0.2f, (float)2.5f, (float)0.0f);
            }
            if (i != 4) {
                GL11.glTranslatef((float)1.5f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            }
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 0, 0);
            GL11.glPopMatrix();
        }
        if (this.currentLayer - 1 >= 0) {
            ItemStack nameStack = new ItemStack((Block)this.blockList.get(this.currentLayer - 1).getRight(), 0, ((Integer)this.blockList.get(this.currentLayer - 1).getLeft()).intValue());
            String renderString = "unknown";
            if (nameStack.func_77973_b() != null) {
                renderString = nameStack.func_82833_r();
            } else if (this.blockList.get(this.currentLayer - 1).getRight() == Blocks.field_150350_a) {
                renderString = "Air";
            }
            String capitalised = renderString.substring(0, 1).toUpperCase() + renderString.substring(1);
            float renderScale = 1.0f;
            int lengthX = this.field_146289_q.func_78256_a(capitalised);
            renderScale = lengthX > 53 ? 53.0f / (float)lengthX : 1.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(guiWidth + 72), (float)(guiHeight + 16), (float)0.0f);
            GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
            this.field_146289_q.func_78276_b(capitalised, 0, 0, 0x919191);
            GL11.glPopMatrix();
            if (this.tooltip.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
                this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiTooltips.png"));
                int fontLengthX = this.field_146289_q.func_78256_a(capitalised) + 5;
                int renderX = mouseX + 10;
                int renderY = mouseY - 5;
                GL11.glPushMatrix();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(renderX, renderY, 0, 0, fontLengthX, 16);
                this.func_73729_b(renderX + fontLengthX, renderY, 0, 16, 2, 16);
                this.field_146289_q.func_78276_b(capitalised, renderX + 4, renderY + 4, 0x919191);
                GL11.glPopMatrix();
            }
        }
        int frequency = 0;
        for (Pair<Integer, Block> pair : this.blockList) {
            if (this.blockList.get(this.currentLayer - 1) == null) continue;
            Block block = (Block)this.blockList.get(this.currentLayer - 1).getRight();
            if (pair.getRight() != block || pair.getLeft() != this.blockList.get(this.currentLayer - 1).getLeft()) continue;
            ++frequency;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(guiWidth + 72), (float)(guiHeight + 26), (float)0.0f);
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.abundancy") + ": " + frequency, 0, 0, 0x919191);
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public String wrapString(String str, int index) {
        String string = str;
        for (int i = 0; i < string.length(); ++i) {
            if (i != index) continue;
            string = string.substring(0, i) + "\n" + string.substring(i);
        }
        return string;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.blockList.clear();
    }

    public void calculate() {
        for (int y = 0; y < this.pos.yCoord; ++y) {
            Block block = this.worldObj.func_147439_a(this.pos.xCoord, y, this.pos.zCoord);
            int metadata = this.worldObj.func_72805_g(this.pos.xCoord, y, this.pos.zCoord);
            this.blockList.add((Pair<Integer, Block>)Pair.of((Object)metadata, (Object)block));
        }
    }

    protected void func_73864_a(int xPos, int yPos, int buttonClicked) {
        super.func_73864_a(xPos, yPos, buttonClicked);
        if (this.upButton.intersects((ReadableRectangle)new Rectangle(xPos, yPos, 1, 1)) && this.currentLayer + 1 <= this.blockList.size() - 1) {
            ++this.currentLayer;
        }
        if (this.downButton.intersects((ReadableRectangle)new Rectangle(xPos, yPos, 1, 1)) && this.currentLayer - 1 >= 1) {
            --this.currentLayer;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

