/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.uncomplication.recipe;

import aroma1997.core.log.LogHelper;
import aroma1997.uncomplication.Uncomplication;
import aroma1997.uncomplication.recipe.ItemWrapper;
import com.google.common.base.Throwables;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.core.IC2;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import java.io.File;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class ReplacementMap
implements Map<ItemWrapper, IRecipeInput> {
    public static ReplacementMap REPLACE_MAP;
    private Map<ItemWrapper, IRecipeInput> map = new HashMap<ItemWrapper, IRecipeInput>();

    ReplacementMap() {
    }

    @Override
    public void clear() {
        this.map.clear();
        LogHelper.logException((String)"Something reset the Uncomplication Replacement List.", (Throwable)new UnsupportedOperationException());
    }

    @Override
    public boolean containsKey(Object o) {
        return this.getValueForStack(o) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getStackForValue(o) != null;
    }

    @Override
    public Set<Map.Entry<ItemWrapper, IRecipeInput>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public IRecipeInput get(Object o) {
        return this.getValueForStack((ItemWrapper)o);
    }

    public IRecipeInput getValueForStack(Object o) {
        if (o instanceof ItemWrapper) {
            return this.map.get(o);
        }
        if (o instanceof ItemStack) {
            if (((ItemStack)o).func_77973_b() == null) {
                return null;
            }
            return this.getValueForStack(new ItemWrapper((ItemStack)o));
        }
        if (o instanceof List) {
            for (Object tmp : (List)o) {
                IRecipeInput tmp1 = this.getValueForStack(tmp);
                if (tmp1 == null) continue;
                return tmp1;
            }
        } else {
            if (o instanceof String) {
                return this.getValueForStack(OreDictionary.getOres((String)((String)o)));
            }
            if (o instanceof IRecipeInput) {
                IRecipeInput input = (IRecipeInput)o;
                for (ItemWrapper item : this.keySet()) {
                    if (!input.matches(item.stack)) continue;
                    return this.getValueForStack(item);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    public ItemWrapper getKeyForValue(Object o) {
        if (o instanceof ItemStack) {
            for (Map.Entry<ItemWrapper, IRecipeInput> e : this.entrySet()) {
                if (!e.getValue().matches((ItemStack)o)) continue;
                return e.getKey();
            }
        } else if (o instanceof List) {
            for (Object tmp : (List)o) {
                ItemWrapper tmp1 = this.getKeyForValue(tmp);
                if (tmp1 == null) continue;
                return tmp1;
            }
        } else {
            if (o instanceof String) {
                return this.getKeyForValue(OreDictionary.getOres((String)((String)o)));
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    public ItemStack getStackForValue(Object o) {
        ItemWrapper item = this.getKeyForValue(o);
        if (item != null) {
            return item.stack;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<ItemWrapper> keySet() {
        return this.map.keySet();
    }

    @Override
    public IRecipeInput put(ItemWrapper key, IRecipeInput value) {
        if (key == null || value == null) {
            throw new NullPointerException("Null is not allowed on the Replacement List.");
        }
        if (value.getInputs().size() == 0) {
            throw new IllegalArgumentException("Empty RecipeInput not allowed on the Replacement List.");
        }
        return this.map.put(key, value);
    }

    public IRecipeInput putCustom(ItemStack item, Object o) {
        ItemWrapper itemWrapper = new ItemWrapper(item);
        RecipeInputItemStack input = null;
        if (o instanceof ItemStack) {
            input = new RecipeInputItemStack((ItemStack)o);
        } else if (o instanceof String) {
            input = new RecipeInputOreDict((String)o);
        } else {
            throw new IllegalArgumentException();
        }
        return this.put(itemWrapper, (IRecipeInput)input);
    }

    @Override
    public void putAll(Map<? extends ItemWrapper, ? extends IRecipeInput> add) {
        for (Map.Entry<? extends ItemWrapper, ? extends IRecipeInput> e : add.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IRecipeInput remove(Object o) {
        IRecipeInput ret = this.map.remove(o);
        LogHelper.logException((String)"Something is removing something from the Uncomplication Replacement List.", (Throwable)new UnsupportedOperationException());
        return ret;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<IRecipeInput> values() {
        return this.map.values();
    }

    static void loadReplacementMap() {
        int amount = 0;
        boolean successful = false;
        Iterator it = ReplacementConfig.get().valueIterator();
        while (it.hasNext()) {
            Config.Value val = (Config.Value)it.next();
            try {
                ReplacementMap.loadReplacement(val);
            }
            catch (Exception e) {
                Uncomplication.log.error("Something went wrong parsing " + val.name + " " + val.value);
                Uncomplication.log.error("Cannot continue...");
                Throwables.propagate((Throwable)e);
            }
            ++amount;
        }
        Uncomplication.log.log(Level.INFO, "Successfully loaded " + amount + " replacement items.");
    }

    private static void loadReplacement(Config.Value value) {
        ItemStack output;
        try {
            output = ConfigUtil.asStack((String)value.name);
        }
        catch (ParseException e) {
            throw new Config.ParseException("invalid key", value, (Exception)e);
        }
        if (output == null) {
            LogHelper.logException((String)("Skipping " + value.name + " due to unresolvable output"), (Throwable)new Config.ParseException("invalid replacement key specified: " + value.name, value));
            return;
        }
        try {
            IRecipeInput input = ConfigUtil.asRecipeInput((Config.Value)value);
            if (input == null || input.getAmount() != 1) {
                throw new IllegalArgumentException("Only 1:1 Mapping allowed on the Replacement map.");
            }
            REPLACE_MAP.put(new ItemWrapper(output), input);
        }
        catch (Config.ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Config.ParseException("generic parse error", value, e);
        }
    }

    public static class ReplacementConfig {
        private static Config config;

        public static void load() {
            config = new Config("uncomplication replacement");
            File configFile = ReplacementConfig.getFile();
            try {
                if (configFile.exists()) {
                    config.load(configFile);
                } else {
                    config.load(ReplacementMap.class.getResourceAsStream("/assets/uncomplication/config/replacement.ini"));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading internal replacement config", e);
            }
            ReplacementConfig.save();
        }

        public static void save() {
            try {
                config.save(ReplacementConfig.getFile());
            }
            catch (Exception e) {
                throw new RuntimeException("Error saving user config", e);
            }
        }

        public static Config get() {
            if (config == null) {
                config = new Config("uncomplication replacement");
            }
            return config;
        }

        private static File getFile() {
            File folder = new File(IC2.platform.getMinecraftDir(), "config/aroma1997");
            folder.mkdirs();
            return new File(folder, "Uncomplication-Replacement.ini");
        }
    }
}

