/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.uncomplication.recipe;

import aroma1997.core.log.LogHelper;
import aroma1997.core.recipes.RecipeUtil;
import aroma1997.uncomplication.Config;
import aroma1997.uncomplication.recipe.ReplacementMap;
import aroma1997.uncomplication.recipe.UncomplicationRecipe;
import ic2.api.recipe.IRecipeInput;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeLoader {
    private static Field advRecipeHidden = null;

    static void loadRecipes() {
        ArrayList<UncomplicationRecipe> toAdd = new ArrayList<UncomplicationRecipe>();
        for (IRecipe recipe : new ArrayList(CraftingManager.func_77594_a().func_77592_b())) {
            UncomplicationRecipe exp;
            ShapedRecipes shape;
            boolean addedReplacement = false;
            if (recipe instanceof ShapedRecipes) {
                shape = (ShapedRecipes)recipe;
                if (RecipeLoader.containsItem(shape.field_77574_d)) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.VShaped, RecipeLoader.addIgnoreSlots(shape.field_77574_d));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            } else if (recipe instanceof ShapelessRecipes) {
                shape = (ShapelessRecipes)recipe;
                if (RecipeLoader.containsItem(shape.field_77579_b)) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.VShapeless, RecipeLoader.addIgnoreSlots(shape.field_77579_b));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            } else if (recipe instanceof ShapedOreRecipe) {
                shape = (ShapedOreRecipe)recipe;
                if (RecipeLoader.containsItem(shape.getInput())) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.FShaped, RecipeLoader.addIgnoreSlots(shape.getInput()));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            } else if (recipe instanceof ShapelessOreRecipe) {
                shape = (ShapelessOreRecipe)recipe;
                if (RecipeLoader.containsItem(shape.getInput())) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.FShapeless, RecipeLoader.addIgnoreSlots(shape.getInput()));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            } else if (recipe instanceof AdvRecipe) {
                shape = (AdvRecipe)recipe;
                if (RecipeLoader.containsItem(shape.input)) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.IC2Shaped, RecipeLoader.addIgnoreSlots((AdvRecipe)shape, shape.input));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            } else if (recipe instanceof AdvShapelessRecipe) {
                shape = (AdvShapelessRecipe)recipe;
                if (RecipeLoader.containsItem(shape.input)) {
                    exp = new UncomplicationRecipe(recipe, RecipeType.IC2Shapeless, RecipeLoader.addIgnoreSlots(shape.input));
                    toAdd.add(exp);
                    addedReplacement = true;
                }
            }
            if (!addedReplacement || !Config.INSTANCE.hideOldRecipes) continue;
            RecipeLoader.hideRecipe(recipe);
        }
        CraftingManager.func_77594_a().func_77592_b().addAll(toAdd);
    }

    static List<Integer> addIgnoreSlots(List<ItemStack> par2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < par2.size(); ++i) {
            if (!RecipeLoader.isItemToIgnore(par2.get(i))) continue;
            list.add(i);
        }
        return list;
    }

    static List<Integer> addIgnoreSlots(ItemStack ... par2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < par2.length; ++i) {
            if (!RecipeLoader.isItemToIgnore(par2[i])) continue;
            list.add(i);
        }
        return list;
    }

    static List<Integer> addIgnoreSlots(Object[] par2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < par2.length; ++i) {
            Object obj = par2[i];
            if (obj == null || !(obj instanceof ItemStack) && !(obj instanceof List) && !(obj instanceof String) && !(obj instanceof IRecipeInput) || !ReplacementMap.REPLACE_MAP.containsKey(obj)) continue;
            list.add(i);
        }
        return list;
    }

    static List<Integer> addIgnoreSlots(AdvRecipe recipe, Object[] par2) {
        Object[] realArgs = new Object[9];
        int mask = recipe.masks[0];
        int j = 0;
        for (int i = 0; i < realArgs.length; ++i) {
            if ((mask >>> 8 - i & 1) != 1) continue;
            realArgs[i] = par2[j];
            ++j;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < realArgs.length; ++i) {
            Object obj = realArgs[i];
            if (obj == null || !(obj instanceof ItemStack) && !(obj instanceof List) && !(obj instanceof String) && !(obj instanceof IRecipeInput) || !ReplacementMap.REPLACE_MAP.containsKey(obj)) continue;
            list.add(i);
        }
        return list;
    }

    static List<Integer> addIgnoreSlots(ArrayList<Object> par2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < par2.size(); ++i) {
            List par1;
            Object obj = par2.get(i);
            if (obj instanceof ItemStack && RecipeLoader.isItemToIgnore((ItemStack)obj)) {
                list.add(i);
            }
            if (obj instanceof IRecipeInput && RecipeLoader.isItemToIgnore(par1 = ((IRecipeInput)obj).getInputs())) {
                list.add(i);
            }
            if (!(obj instanceof ArrayList) || !RecipeLoader.isItemToIgnore((ArrayList)obj)) continue;
            list.add(i);
        }
        return list;
    }

    static boolean isItemToIgnore(List par1) {
        for (int i = 0; i < par1.size(); ++i) {
            List list;
            Object obj = par1.get(i);
            if (obj instanceof ItemStack && RecipeLoader.isItemToIgnore((ItemStack)obj)) {
                return true;
            }
            if (obj instanceof IRecipeInput && RecipeLoader.isItemToIgnore(list = ((IRecipeInput)obj).getInputs())) {
                return true;
            }
            if (!(obj instanceof ArrayList) || !RecipeLoader.isItemToIgnore((ArrayList)obj)) continue;
            return true;
        }
        return false;
    }

    static boolean isItemToIgnore(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        return ReplacementMap.REPLACE_MAP.containsValue(par1);
    }

    private static boolean containsItem(List par1) {
        if (par1 == null) {
            return false;
        }
        for (int i = 0; i < par1.size(); ++i) {
            Object obj = par1.get(i);
            if (obj == null || !(obj instanceof ItemStack) && !(obj instanceof List) && !(obj instanceof String) && !(obj instanceof IRecipeInput) || !ReplacementMap.REPLACE_MAP.containsKey(obj)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsItem(Object[] par1) {
        for (int i = 0; i < par1.length; ++i) {
            Object obj = par1[i];
            if (obj == null || !(obj instanceof ItemStack) && !(obj instanceof List) && !(obj instanceof String) && !(obj instanceof IRecipeInput) || !ReplacementMap.REPLACE_MAP.containsKey(obj)) continue;
            return true;
        }
        return false;
    }

    private static void hideRecipe(IRecipe recipe) {
        try {
            if (recipe instanceof AdvRecipe) {
                if (advRecipeHidden == null && !(advRecipeHidden = AdvRecipe.class.getField("hidden")).isAccessible()) {
                    advRecipeHidden.setAccessible(true);
                }
                advRecipeHidden.set(recipe, true);
            } else if (recipe instanceof AdvShapelessRecipe) {
                ((AdvShapelessRecipe)recipe).hidden = true;
            } else {
                RecipeUtil.hideRecipe((IRecipe)recipe);
            }
        }
        catch (IllegalArgumentException e) {
            LogHelper.logException((String)("Failed to hide recipe of class " + recipe.getClass().getCanonicalName() + ". This should never happen"), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LogHelper.logException((String)"Failed to hide IC2 Shaped Recipe. Probably due to a version mismatch.", (Throwable)e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            LogHelper.logException((String)"Could not create hidden recipe. Ignoring...", (Throwable)e);
        }
    }

    public static enum RecipeType {
        VShaped,
        VShapeless,
        FShaped,
        FShapeless,
        IC2Shaped,
        IC2Shapeless;

    }
}

