/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.uncomplication.enet;

import aroma1997.uncomplication.Uncomplication;
import aroma1997.uncomplication.enet.EnergyNetLocal;
import aroma1997.uncomplication.enet.EnergyTransferList;
import aroma1997.uncomplication.enet.EventHandler;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.api.energy.IEnergyNet;
import ic2.api.energy.NodeStats;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetGlobal
implements IEnergyNet {
    private static Map<World, EnergyNetLocal> worldToEnergyNetMap = new WeakHashMap<World, EnergyNetLocal>();
    private static EventHandler eventHandler;

    public TileEntity getTileEntity(World world, int x, int y, int z) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != null) {
            return local.getTileEntity(x, y, z);
        }
        return null;
    }

    public TileEntity getNeighbor(TileEntity te, ForgeDirection dir) {
        if (te == null) {
            return null;
        }
        return this.getTileEntity(te.func_145831_w(), te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ);
    }

    public double getTotalEnergyEmitted(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0.0;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(tileEntity.func_145831_w());
        if (local != null) {
            return local.getTotalEnergyEmitted(tileEntity);
        }
        return 0.0;
    }

    public double getTotalEnergySunken(TileEntity tileEntity) {
        if (tileEntity == null) {
            return 0.0;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(tileEntity.func_145831_w());
        if (local != null) {
            return local.getTotalEnergySunken(tileEntity);
        }
        return 0.0;
    }

    public double getPowerFromTier(int tier) {
        return 8 << tier * 2;
    }

    public NodeStats getNodeStats(TileEntity te) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(te.func_145831_w());
        if (local == null) {
            return new NodeStats(0.0, 0.0, 0.0);
        }
        return local.getNodeStats(te);
    }

    public int getTierFromPower(double power) {
        if (power <= 0.0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0));
    }

    public static EnergyNetLocal getForWorld(World world) {
        if (world == null) {
            Uncomplication.log.warn("EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new EnergyNetLocal(world));
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickStart(World world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickStart();
        }
    }

    public static void onTickEnd(World world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    public static EnergyNetGlobal initialize() {
        eventHandler = new EventHandler();
        EnergyNetLocal.list = new EnergyTransferList();
        Map map = (Map)ReflectionHelper.getPrivateValue(EventBus.class, (Object)MinecraftForge.EVENT_BUS, (String[])new String[]{"listeners"});
        Object toUnregister = null;
        for (Object listener : map.keySet()) {
            if (listener == null || !listener.getClass().equals(ic2.core.energy.EventHandler.class)) continue;
            toUnregister = listener;
            break;
        }
        if (toUnregister != null) {
            MinecraftForge.EVENT_BUS.unregister(toUnregister);
        }
        return new EnergyNetGlobal();
    }

    public static void onWorldUnload(World world) {
        EnergyNetLocal local = worldToEnergyNetMap.remove(world);
        if (local != null) {
            local.onUnload();
        }
    }
}

