/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.uncomplication.blocks.te;

import aroma1997.uncomplication.BlocksItemsUncomplication;
import aroma1997.uncomplication.blocks.container.ContainerUUMatter;
import aroma1997.uncomplication.blocks.gui.GuiUUMatter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Redstone;
import ic2.core.block.comp.TileEntityComponent;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.network.NetworkManager;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityUUMatter
extends TileEntityElectricMachine
implements IHasGui,
IUpgradableBlock {
    public static final int baseUuCost = 10000000;
    private static final int defaultTier = 3;
    public static final int scrapMultiplier = 5;
    public int soundTicker = IC2.random.nextInt(32);
    public int scrap = 0;
    private final int StateIdle = 0;
    private final int StateRunning = 1;
    private final int StateRunningScrap = 2;
    private int state = 0;
    private int prevState = 0;
    private AudioSource audioSource;
    private AudioSource audioSourceScrap;
    private final Redstone redstone;
    public final InvSlotProcessableGeneric amplifierSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "scrap", 0, 1, Recipes.matterAmplifier);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 2, 3);

    public TileEntityUUMatter() {
        super(640000000, 3, -1);
        this.redstone = (Redstone)this.addComponent((TileEntityComponent)new Redstone((TileEntityBlock)this));
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.scrap = nbttagcompound.func_74762_e("scrap");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("scrap", this.scrap);
    }

    public String func_145825_b() {
        return "Mass Fabricator";
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (this.redstone.hasRedstoneInput() || this.energy <= 0.0) {
            this.setState(0);
            this.setActive(false);
        } else {
            this.setState(this.scrap > 0 || this.amplificationIsAvailable() ? 2 : 1);
            this.setActive(true);
            if (this.scrap < 1000 && this.consumeAmplifier()) {
                needsInvUpdate = true;
            }
            while (this.energy >= 1.0E7 && this.attemptGeneration()) {
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSource = null;
            this.audioSourceScrap = null;
        }
        super.onUnloaded();
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        this.upgradeSlot.onChanged();
        this.setTier(3 + this.upgradeSlot.extraTier);
    }

    public boolean attemptGeneration() {
        if (this.outputSlot.add(new ItemStack(BlocksItemsUncomplication.matter)) == 0) {
            this.energy -= 1.0E7;
            return true;
        }
        return false;
    }

    public double getDemandedEnergy() {
        if (this.redstone.hasRedstoneInput()) {
            return 0.0;
        }
        return (double)this.maxEnergy - this.energy;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxEnergy || this.redstone.hasRedstoneInput()) {
            return amount;
        }
        if (amount > (double)this.scrap && this.scrap != 0 && this.amplificationIsAvailable()) {
            this.consumeAmplifier();
        }
        int bonus = Math.min((int)amount, this.scrap);
        this.scrap -= bonus;
        this.energy += amount + (double)(5 * bonus);
        return 0.0;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy * 100.0 / 1.0E7), 100);
        return "" + p + "%";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerUUMatter(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiUUMatter(new ContainerUUMatter(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    private void setState(int state) {
        this.state = state;
        if (this.prevState != state) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "state");
        }
        this.prevState = state;
    }

    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(1);
        ret.add("state");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("state") && this.prevState != this.state) {
            switch (this.state) {
                case 0: {
                    if (this.audioSource != null) {
                        this.audioSource.stop();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 1: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.stop();
                    break;
                }
                case 2: {
                    if (this.audioSource == null) {
                        this.audioSource = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSourceScrap == null) {
                        this.audioSourceScrap = IC2.audioManager.createSource((Object)this, PositionSpec.Center, "Generators/MassFabricator/MassFabScrapSolo.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (this.audioSource != null) {
                        this.audioSource.play();
                    }
                    if (this.audioSourceScrap == null) break;
                    this.audioSourceScrap.play();
                }
            }
            this.prevState = this.state;
        }
        super.onNetworkUpdate(field);
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    public boolean amplificationIsAvailable() {
        if (this.scrap > 0) {
            return true;
        }
        RecipeOutput amplifier = this.amplifierSlot.process();
        return amplifier != null && amplifier.metadata.func_74762_e("amplification") > 0;
    }

    public boolean consumeAmplifier() {
        RecipeOutput amplifier = this.amplifierSlot.process();
        if (amplifier != null) {
            this.amplifierSlot.consume();
            this.scrap += amplifier.metadata.func_74762_e("amplification");
            return true;
        }
        return false;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemConsuming, UpgradableProperty.ItemProducing, UpgradableProperty.RedstoneSensitive, UpgradableProperty.Transformer);
    }
}

