/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.EmptyNetworkCache;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.cache.NetworkCache;

public class WIPCacheRegistry {
    public static final EmptyNetworkCache EMPTY_CACHE = new EmptyNetworkCache();
    private static ArrayList<INetworkCache> caches = new ArrayList();

    public static void removeAll() {
        caches.clear();
    }

    public static Map.Entry<BlockCoords, ForgeDirection> getFirstConnection(int networkID) {
        INetworkCache network = WIPCacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getExternalBlock(true);
        }
        return null;
    }

    public static ArrayList<BlockCoords> getCacheList(CacheTypes type, int networkID) {
        INetworkCache network = WIPCacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getConnections(type, true);
        }
        return new ArrayList<BlockCoords>();
    }

    public static LinkedHashMap<BlockCoords, ForgeDirection> getChannelArray(int networkID) {
        INetworkCache network = WIPCacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getExternalBlocks(true);
        }
        return new LinkedHashMap<BlockCoords, ForgeDirection>();
    }

    public static INetworkCache getCache(int networkID) {
        INetworkCache networkCache = null;
        if (caches.size() > networkID) {
            networkCache = caches.get(networkID);
        }
        if (networkCache == null) {
            return EMPTY_CACHE;
        }
        return networkCache;
    }

    public static void refreshCache(int oldID, int newID) {
        INetworkCache networkCache;
        if (oldID != newID) {
            caches.remove(oldID);
        }
        if ((networkCache = caches.get(newID)) != null && networkCache instanceof INetworkCache) {
            ((NetworkCache)networkCache).refreshCache(newID);
        }
        NetworkCache network = new NetworkCache();
        network.refreshCache(newID);
        caches.set(newID, network);
    }

    public static ArrayList<INetworkCache> getNetworkCache() {
        return caches;
    }
}

