/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.logistics.Logistics;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.registries.CacheRegistry;

public class WIPCableRegistry {
    private static ArrayList<Integer> empty = new ArrayList();
    private static Map<Integer, ArrayList<BlockCoords>> cables = new THashMap();
    private static Map<Integer, ArrayList<BlockCoords>> connections = new THashMap();

    public static int createNetwork() {
        Iterator iterator = ((ArrayList)empty.clone()).iterator();
        if (iterator.hasNext()) {
            Integer integer = (Integer)iterator.next();
            cables.put(integer, new ArrayList());
            connections.put(integer, new ArrayList());
            return integer;
        }
        int size = cables.size();
        cables.put(size, new ArrayList());
        connections.put(size, new ArrayList());
        return size;
    }

    public static void validateArray(Map<Integer, ArrayList<BlockCoords>> all, int array) {
        if (all.get(array) == null) {
            all.put(array, new ArrayList());
        }
    }

    public static void addConnection(int registryID, BlockCoords coords) {
        if (registryID != -1 && coords != null) {
            try {
                WIPCableRegistry.validateArray(connections, registryID);
                if (!coords.contains((List)connections.get(registryID))) {
                    connections.get(registryID).add(coords);
                }
                CacheRegistry.refreshCache(registryID, registryID);
            }
            catch (Exception exception) {
                Logistics.logger.error("Failed to add connection to : " + registryID + " : " + exception.getLocalizedMessage());
            }
        }
    }

    public static void removeConnection(int registryID, BlockCoords coords) {
        if (registryID != -1 && coords != null) {
            try {
                WIPCableRegistry.validateArray(connections, registryID);
                for (BlockCoords coord : (ArrayList)connections.get(registryID).clone()) {
                    if (!coords.equals((Object)coord)) continue;
                    connections.get(registryID).remove(coord);
                }
                CacheRegistry.refreshCache(registryID, registryID);
            }
            catch (Exception exception) {
                Logistics.logger.error("Failed to remove connection from : " + registryID + " : " + exception.getLocalizedMessage());
            }
        }
    }

    public static void addCable(int registryID, IDataCable cable) {
        if (registryID != -1 && cable.getCoords() != null) {
            try {
                WIPCableRegistry.validateArray(cables, registryID);
                if (!cable.getCoords().contains((List)cables.get(registryID))) {
                    cables.get(registryID).add(cable.getCoords());
                }
                boolean updateNetwork = false;
                for (int i = 0; i < 6; ++i) {
                    IDataCable adjCable;
                    BlockCoords adj;
                    Object target;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                    if (cable.isBlocked(dir.getOpposite()) || (target = FMPHelper.getTile((Object)(adj = BlockCoords.translateCoords((BlockCoords)cable.getCoords(), (ForgeDirection)dir)).getTileEntity())) == null || !(target instanceof IDataCable) || (adjCable = (IDataCable)target).isBlocked(dir) || adjCable.registryID() == cable.registryID()) continue;
                    int networkID = adjCable.registryID();
                    cables.get(registryID).addAll(WIPCableRegistry.getCables(networkID));
                    cables.get(networkID).clear();
                    updateNetwork = true;
                }
                if (updateNetwork) {
                    WIPCableRegistry.updateNetwork(registryID);
                }
                CacheRegistry.refreshCache(registryID, registryID);
            }
            catch (Exception exception) {
                Logistics.logger.error("Failed to add cable to : " + registryID + " : " + exception.getLocalizedMessage());
            }
        }
    }

    public static void removeCable(int registryID, IDataCable cable) {
        if (registryID != -1 && cable.getCoords() != null) {
            try {
                WIPCableRegistry.validateArray(connections, registryID);
                for (BlockCoords coord : (ArrayList)connections.get(registryID).clone()) {
                    if (!cable.getCoords().equals((Object)coord)) continue;
                    connections.get(registryID).remove(coord);
                }
                CacheRegistry.refreshCache(registryID, registryID);
            }
            catch (Exception exception) {
                Logistics.logger.error("Failed to remove cable from : " + registryID + " : " + exception.getLocalizedMessage());
            }
        }
    }

    public static void updateNetwork(int registryID) {
        WIPCableRegistry.validateArray(cables, registryID);
        ArrayList toClear = new ArrayList();
        for (BlockCoords coords : (ArrayList)cables.get(registryID).clone()) {
            IDataCable cable;
            Object target = FMPHelper.getTile((Object)coords.getTileEntity());
            if (target == null || !(target instanceof IDataCable) || !(cable = (IDataCable)target).getCableType().canConnect(cable.getCableType()) || cable.registryID() == registryID) continue;
            cable.setRegistryID(registryID);
            cable.refreshConnections();
        }
        for (Integer id : toClear) {
            connections.remove(id);
        }
    }

    public static ArrayList<BlockCoords> getCables(int registryID) {
        return cables.get(registryID) == null ? new ArrayList<BlockCoords>() : cables.get(registryID);
    }

    public static ArrayList<BlockCoords> getConnections(int registryID) {
        return connections.get(registryID) == null ? new ArrayList<BlockCoords>() : connections.get(registryID);
    }

    public static void removeAll() {
        cables.clear();
        connections.clear();
    }
}

