/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.minecraft.tileentity.TileEntity;
import sonar.core.helpers.RegistryHelper;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.InfoInteractionHandler;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.info.interaction.FluidInventoryInteraction;
import sonar.logistics.info.interaction.InventoryInteraction;
import sonar.logistics.info.interaction.StoredFluidInteraction;
import sonar.logistics.info.interaction.StoredStackInteraction;

public class InfoInteractionRegistry
extends RegistryHelper<InfoInteractionHandler> {
    public void register() {
        this.registerObject(new InventoryInteraction());
        this.registerObject(new StoredStackInteraction());
        this.registerObject(new FluidInventoryInteraction());
        this.registerObject(new StoredFluidInteraction());
    }

    public String registeryType() {
        return "Info Interaction";
    }

    public InfoInteractionHandler getInteractionHandler(ILogicInfo info, ScreenType type, TileEntity te) {
        for (InfoInteractionHandler handler : this.getObjects()) {
            Type subType;
            Class<?> handlerClass = handler.getClass();
            if (handlerClass == null || (subType = ((ParameterizedType)handlerClass.getGenericSuperclass()).getActualTypeArguments()[0]) == null || info == null || subType != info.getClass()) continue;
            return handler;
        }
        return null;
    }
}

