/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.cache.IRefreshCache;
import sonar.logistics.registries.CableRegistry;
import sonar.logistics.registries.CacheRegistry;

public class EventRegistry {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            LinkedHashMap networks = (LinkedHashMap)CacheRegistry.getNetworkCache().clone();
            if (networks.isEmpty()) {
                return;
            }
            for (Map.Entry set : networks.entrySet()) {
                INetworkCache cache = (INetworkCache)set.getValue();
                if (cache instanceof IRefreshCache) {
                    ((IRefreshCache)cache).updateNetwork(cache.getNetworkID());
                }
                if (CableRegistry.getCables(cache.getNetworkID()).size() != 0) continue;
                CacheRegistry.getNetworkCache().remove(cache.getNetworkID());
            }
        }
    }
}

