/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import sonar.core.api.BlockCoords;
import sonar.logistics.api.utils.IdentifiedCoords;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;
import sonar.logistics.registries.BlockRegistry;

public class EmitterRegistry {
    private static Map<String, List<BlockCoords>> privateEmitters = new THashMap();
    private static ArrayList<BlockCoords> publicEmitters = new ArrayList();

    public static void removeAll() {
        privateEmitters.clear();
        publicEmitters.clear();
    }

    public static List<IdentifiedCoords> getEmitters(String playerName, boolean isPrivate) {
        if (playerName == null || playerName.isEmpty()) {
            return null;
        }
        ArrayList<IdentifiedCoords> emitterList = new ArrayList<IdentifiedCoords>();
        ArrayList array = (ArrayList)publicEmitters.clone();
        if (privateEmitters.get(playerName) != null) {
            array.addAll((Collection)privateEmitters.get(playerName));
        }
        for (BlockCoords coords : array) {
            TileEntity tile;
            if (coords == null || (tile = coords.getTileEntity()) == null || !(tile instanceof TileEntityDataEmitter)) continue;
            TileEntityDataEmitter dataEmitter = (TileEntityDataEmitter)tile;
            if (tile.func_145831_w() == null || tile.func_145837_r()) continue;
            EnumChatFormatting format = (Boolean)dataEmitter.isPrivate.getObject() != false ? EnumChatFormatting.WHITE : EnumChatFormatting.GREEN;
            emitterList.add(new IdentifiedCoords(format + (String)dataEmitter.clientName.getObject(), new ItemStack(BlockRegistry.dataEmitter), coords));
        }
        return emitterList;
    }

    public static void addEmitters(String playerName, BlockCoords emitter, boolean isPrivate) {
        if (emitter != null || playerName != null) {
            if (isPrivate) {
                if (privateEmitters.get(playerName) == null) {
                    privateEmitters.put(playerName, new ArrayList());
                }
                if (!privateEmitters.get(playerName).contains(emitter)) {
                    privateEmitters.get(playerName).add(emitter);
                } else {
                    privateEmitters.get(playerName).remove(emitter);
                    privateEmitters.get(playerName).add(emitter);
                }
            } else {
                publicEmitters.add(emitter);
            }
        }
    }

    public static void removeEmitter(String playerName, BlockCoords emitter, boolean isPrivate) {
        block9: {
            if (emitter == null && playerName == null) break block9;
            if (isPrivate) {
                if (privateEmitters.get(playerName) == null) {
                    return;
                }
                int i = 0;
                ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
                for (BlockCoords coords : privateEmitters.get(playerName)) {
                    if (BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)emitter)) {
                        removeList.add(coords);
                    }
                    ++i;
                }
                for (BlockCoords remove : removeList) {
                    privateEmitters.get(playerName).remove(remove);
                }
            } else {
                int i = 0;
                ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
                for (BlockCoords coords : publicEmitters) {
                    if (BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)emitter)) {
                        removeList.add(coords);
                    }
                    ++i;
                }
                for (BlockCoords remove : removeList) {
                    publicEmitters.remove(remove);
                }
            }
        }
    }
}

