/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.helpers.DisplayHelper;

public class DisplayRegistry {
    private static Map<Integer, List<BlockCoords>> screens = new THashMap();
    private static ArrayList<Integer> needUpdate = new ArrayList();

    public static void removeAll() {
        screens.clear();
    }

    public static boolean hasChanged(int registryID) {
        Integer inte = registryID;
        return needUpdate.contains(inte);
    }

    public static void setChanged(int registryID) {
        Integer inte = registryID;
        if (!needUpdate.contains(inte)) {
            needUpdate.add(inte);
        }
    }

    public static void onUpdate(int registryID) {
        Integer inte = registryID;
        if (needUpdate.contains(inte)) {
            needUpdate.remove(inte);
        }
    }

    public static int getNextAvailableID() {
        for (int i = 0; i < screens.size(); ++i) {
            if (screens.get(i) != null && !screens.get(i).isEmpty() && screens.get(i).size() != 0) continue;
            return i;
        }
        return screens.size();
    }

    public static List<BlockCoords> getScreens(int registryID) {
        if (registryID == -1) {
            return new ArrayList<BlockCoords>();
        }
        List<BlockCoords> coords = screens.get(registryID);
        if (coords == null) {
            return new ArrayList<BlockCoords>();
        }
        return coords;
    }

    public static void addScreens(int registryID, List<BlockCoords> cables) {
        for (BlockCoords coords : cables) {
            DisplayRegistry.addScreen(registryID, coords);
        }
    }

    public static void addScreen(int registryID, BlockCoords cable) {
        Object target;
        if (registryID != -1 && cable != null && (target = FMPHelper.checkObject((Object)cable.getTileEntity())) != null && target instanceof ILargeDisplay) {
            if (screens.get(registryID) == null) {
                screens.put(registryID, new ArrayList());
                screens.get(registryID).add(cable);
                ((ILargeDisplay)target).setRegistryID(registryID);
                DisplayRegistry.setHandler(registryID);
                return;
            }
            ArrayList removeList = new ArrayList();
            for (BlockCoords coords : screens.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)cable)) continue;
                DisplayRegistry.setHandler(registryID);
                return;
            }
            screens.get(registryID).add(cable);
            ((ILargeDisplay)target).setRegistryID(registryID);
            DisplayRegistry.setHandler(registryID);
        }
    }

    public static void removeScreen(int registryID, ILargeDisplay cable) {
        if (registryID != -1 && cable.getCoords() != null) {
            ILargeDisplay tile;
            Object target;
            if (screens.get(registryID) == null) {
                return;
            }
            ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
            for (BlockCoords coords : screens.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)cable.getCoords())) continue;
                removeList.add(coords);
            }
            for (BlockCoords remove : removeList) {
                screens.get(registryID).remove(remove);
            }
            ArrayList oldCables = new ArrayList();
            if (screens.get(registryID) != null) {
                oldCables.addAll(screens.get(registryID));
                screens.get(registryID).clear();
            }
            int newID = DisplayRegistry.getNextAvailableID();
            for (BlockCoords oldScreens : oldCables) {
                target = FMPHelper.checkObject((Object)oldScreens.getTileEntity());
                if (target == null || !(target instanceof ILargeDisplay)) continue;
                tile = (ILargeDisplay)target;
                tile.setRegistryID(-1);
            }
            for (BlockCoords oldCable : oldCables) {
                target = FMPHelper.checkObject((Object)oldCable.getTileEntity());
                if (target == null || !(target instanceof ILargeDisplay)) continue;
                tile = (ILargeDisplay)target;
                DisplayHelper.addScreen(tile);
            }
            DisplayRegistry.setHandler(newID);
        }
    }

    public static void connectScreens(int newID, int secondaryID) {
        ArrayList<BlockCoords> oldCables = new ArrayList<BlockCoords>();
        if (screens.get(secondaryID) != null) {
            oldCables.addAll((Collection<BlockCoords>)screens.get(secondaryID));
            screens.get(secondaryID).clear();
        }
        DisplayRegistry.addScreens(newID, oldCables);
        DisplayRegistry.setHandler(newID);
    }

    public static void setHandler(int id) {
        List<BlockCoords> coords = DisplayRegistry.getScreens(id);
        int y = 1000;
        BlockCoords handler = null;
        for (BlockCoords coord : coords) {
            if (coord.getY() >= y) continue;
            handler = coord;
            y = coord.getY();
        }
        if (handler != null && y != 1000) {
            for (BlockCoords coord : coords) {
                TileHandler object = FMPHelper.getHandler((Object)coord.getTileEntity());
                if (object == null || !(object instanceof LargeDisplayScreenHandler)) continue;
                LargeDisplayScreenHandler screen = (LargeDisplayScreenHandler)object;
                if (BlockCoords.equalCoords((BlockCoords)handler, (BlockCoords)coord)) {
                    screen.isHandler.setObject((Object)true);
                    screen.resetHandler = true;
                    continue;
                }
                if (!((Boolean)screen.isHandler.getObject()).booleanValue()) continue;
                screen.isHandler.setObject((Object)false);
                screen.resetHandler = true;
            }
        }
        DisplayRegistry.setChanged(id);
    }
}

