/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.EmptyNetworkCache;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.cache.NetworkCache;

public final class CacheRegistry {
    private static final EmptyNetworkCache EMPTY_CACHE = new EmptyNetworkCache();
    private static LinkedHashMap<Integer, INetworkCache> cache = new LinkedHashMap();

    public static void removeAll() {
        cache.clear();
    }

    public static Map.Entry<BlockCoords, ForgeDirection> getFirstConnection(int networkID) {
        INetworkCache network = CacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getExternalBlock(true);
        }
        return null;
    }

    public static ArrayList<BlockCoords> getCacheList(CacheTypes type, int networkID) {
        INetworkCache network = CacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getConnections(type, true);
        }
        return new ArrayList<BlockCoords>();
    }

    public static LinkedHashMap<BlockCoords, ForgeDirection> getChannelArray(int networkID) {
        INetworkCache network = CacheRegistry.getCache(networkID);
        if (network != null) {
            return network.getExternalBlocks(true);
        }
        return new LinkedHashMap<BlockCoords, ForgeDirection>();
    }

    public static INetworkCache getCache(int networkID) {
        INetworkCache networkCache = cache.get(networkID);
        if (networkCache == null) {
            return EMPTY_CACHE;
        }
        return networkCache;
    }

    public static void refreshCache(int oldID, int newID) {
        INetworkCache networkCache;
        if (oldID != newID) {
            cache.remove(oldID);
        }
        if ((networkCache = cache.get(newID)) != null && networkCache instanceof INetworkCache) {
            ((NetworkCache)networkCache).refreshCache(newID);
        }
        NetworkCache network = new NetworkCache();
        network.refreshCache(newID);
        cache.put(newID, network);
    }

    public static LinkedHashMap<Integer, INetworkCache> getNetworkCache() {
        return cache;
    }
}

