/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.registries;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.registries.CacheRegistry;

public class CableRegistry {
    private static Map<Integer, ArrayList<BlockCoords>> cables = new THashMap();
    private static Map<Integer, ArrayList<BlockCoords>> connections = new THashMap();

    public static void removeAll() {
        connections.clear();
        cables.clear();
    }

    public static int getNextAvailableID() {
        for (int i = 0; i < cables.size(); ++i) {
            if (cables.get(i) != null && !cables.get(i).isEmpty() && cables.get(i).size() != 0) continue;
            return i;
        }
        return cables.size();
    }

    public static ArrayList<BlockCoords> getCables(int registryID) {
        if (registryID == -1) {
            return new ArrayList<BlockCoords>();
        }
        ArrayList<BlockCoords> coords = cables.get(registryID);
        if (coords == null) {
            return new ArrayList<BlockCoords>();
        }
        return coords;
    }

    public static ArrayList<BlockCoords> getConnections(int registryID) {
        if (registryID == -1) {
            return new ArrayList<BlockCoords>();
        }
        ArrayList<BlockCoords> coords = connections.get(registryID);
        if (coords == null) {
            return new ArrayList<BlockCoords>();
        }
        return coords;
    }

    public static void addCables(int registryID, ArrayList<BlockCoords> cables) {
        for (BlockCoords coords : cables) {
            CableRegistry.addCable(registryID, coords);
        }
    }

    public static void addCable(int registryID, BlockCoords cable) {
        Object target;
        if (registryID != -1 && cable != null && (target = FMPHelper.checkObject((Object)cable.getTileEntity())) != null && target instanceof IDataCable) {
            if (cables.get(registryID) == null) {
                cables.put(registryID, new ArrayList());
                cables.get(registryID).add(cable);
                ((IDataCable)target).setRegistryID(registryID);
                return;
            }
            ArrayList removeList = new ArrayList();
            for (BlockCoords coords : cables.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)cable)) continue;
                return;
            }
            cables.get(registryID).add(cable);
            ((IDataCable)target).setRegistryID(registryID);
            CacheRegistry.refreshCache(registryID, registryID);
        }
    }

    public static void addConnections(int registryID, ArrayList<BlockCoords> connections) {
        for (BlockCoords coords : connections) {
            CableRegistry.addConnection(registryID, coords);
        }
    }

    public static void addConnection(int registryID, BlockCoords connection) {
        if (registryID != -1 && connection != null) {
            if (connections.get(registryID) == null) {
                connections.put(registryID, new ArrayList());
                connections.get(registryID).add(connection);
                CacheRegistry.refreshCache(registryID, registryID);
                return;
            }
            ArrayList removeList = new ArrayList();
            for (BlockCoords coords : connections.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)connection)) continue;
                return;
            }
            connections.get(registryID).add(connection);
            CacheRegistry.refreshCache(registryID, registryID);
        }
    }

    public static void removeCable(int registryID, IDataCable cable) {
        if (registryID != -1 && cable.getCoords() != null) {
            ILogicTile tile;
            Object target;
            if (cables.get(registryID) == null) {
                return;
            }
            ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
            for (BlockCoords coords : cables.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)cable.getCoords())) continue;
                removeList.add(coords);
            }
            for (BlockCoords remove : removeList) {
                cables.get(registryID).remove(remove);
            }
            ArrayList oldCables = new ArrayList();
            if (cables.get(registryID) != null) {
                oldCables.addAll(cables.get(registryID));
                cables.get(registryID).clear();
            }
            ArrayList oldConnections = new ArrayList();
            if (connections.get(registryID) != null) {
                oldConnections.addAll(connections.get(registryID));
                connections.get(registryID).clear();
            }
            int newID = CableRegistry.getNextAvailableID();
            for (BlockCoords oldCable : oldCables) {
                target = FMPHelper.checkObject((Object)oldCable.getTileEntity());
                if (target == null || !(target instanceof IDataCable)) continue;
                tile = (IDataCable)target;
                tile.setRegistryID(-1);
            }
            for (BlockCoords oldCable : oldCables) {
                target = FMPHelper.checkObject((Object)oldCable.getTileEntity());
                if (target == null || !(target instanceof IDataCable)) continue;
                tile = (IDataCable)target;
                tile.addCable();
            }
            for (BlockCoords coords : oldConnections) {
                target = FMPHelper.checkObject((Object)coords.getTileEntity());
                if (target == null || !(target instanceof IInfoEmitter)) continue;
                tile = (IInfoEmitter)target;
                tile.removeConnections();
                tile.addConnections();
            }
        }
    }

    public static void connectNetworks(int newID, int secondaryID) {
        ArrayList<BlockCoords> oldCables = new ArrayList<BlockCoords>();
        if (cables.get(secondaryID) != null) {
            oldCables.addAll((Collection)cables.get(secondaryID));
            cables.get(secondaryID).clear();
        }
        ArrayList<BlockCoords> oldConnections = new ArrayList<BlockCoords>();
        if (connections.get(secondaryID) != null) {
            oldConnections.addAll((Collection<BlockCoords>)connections.get(secondaryID));
            connections.get(secondaryID).clear();
        }
        CableRegistry.addCables(newID, oldCables);
        CableRegistry.addConnections(newID, oldConnections);
        CacheRegistry.refreshCache(secondaryID, newID);
    }

    public static void removeConnection(int registryID, BlockCoords connection) {
        if (registryID != -1 && connection != null) {
            if (connections.get(registryID) == null) {
                return;
            }
            ArrayList<BlockCoords> removeList = new ArrayList<BlockCoords>();
            for (BlockCoords coords : connections.get(registryID)) {
                if (!BlockCoords.equalCoords((BlockCoords)coords, (BlockCoords)connection)) continue;
                removeList.add(coords);
            }
            for (BlockCoords remove : removeList) {
                connections.get(registryID).remove(remove);
            }
            CacheRegistry.refreshCache(registryID, registryID);
        }
    }
}

