/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketCoords;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.common.handlers.DisplayScreenHandler;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.registries.DisplayRegistry;

public abstract class ScreenHandler<T extends PacketCoords>
implements IMessageHandler<T, IMessage> {
    public abstract void handlePacket(TileEntity var1, T var2, MessageContext var3, ILogicInfo var4, EntityPlayerMP var5, boolean var6);

    public final IMessage onMessage(T message, MessageContext ctx) {
        World world;
        TileEntity te;
        TileHandler handler;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player != null && (handler = FMPHelper.getHandler((Object)(te = (world = ctx.getServerHandler().field_147369_b.field_70170_p).func_147438_o(((PacketCoords)message).xCoord, ((PacketCoords)message).yCoord, ((PacketCoords)message).zCoord)))) != null && handler instanceof DisplayScreenHandler) {
            INetworkCache network;
            List<BlockCoords> displays;
            DisplayScreenHandler screen = (DisplayScreenHandler)handler;
            boolean doubleClick = false;
            if (te.func_145831_w().func_82737_E() - screen.lastClickTime < 10L && player.getPersistentID().equals(screen.lastClickUUID)) {
                doubleClick = true;
            }
            screen.lastClickTime = world.func_82737_E();
            screen.lastClickUUID = player.getPersistentID();
            ILogicInfo screenInfo = screen.dInfo[0];
            if (te instanceof ILargeDisplay && !(displays = DisplayRegistry.getScreens(((ILargeDisplay)te).registryID())).isEmpty()) {
                boolean found = false;
                for (BlockCoords display : displays) {
                    te = display.getTileEntity();
                    TileHandler tilehandler = FMPHelper.getHandler((Object)te);
                    if (tilehandler == null || !(tilehandler instanceof LargeDisplayScreenHandler)) continue;
                    LargeDisplayScreenHandler handlerDisplay = (LargeDisplayScreenHandler)tilehandler;
                    if (!((Boolean)handlerDisplay.isHandler.getObject()).booleanValue()) continue;
                    screenInfo = handlerDisplay.dInfo[0];
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            if ((network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite())) == null) {
                return null;
            }
            ScreenType screenType = ScreenType.NORMAL;
            if (te instanceof ILargeDisplay) {
                screenType = ScreenType.LARGE;
                if (((ILargeDisplay)te).getSizing() != null) {
                    screenType = ScreenType.CONNECTED;
                }
            }
            this.handlePacket(te, message, ctx, screenInfo, player, doubleClick);
        }
        return null;
    }
}

